/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import journeymap.common.LoaderHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionHelper {
    public static String getDimName(Entity entity) {
        return DimensionHelper.getDimName(entity.m_9236_());
    }

    public static String getDimName(@Nullable Level world) {
        if (world != null) {
            return DimensionHelper.getDimName((ResourceKey<Level>)world.m_46472_());
        }
        return "overworld";
    }

    public static String getDimName(ResourceKey<Level> dimensionKey) {
        return dimensionKey.m_135782_().m_135815_();
    }

    public static String getDimName(String key) {
        return key.split(":")[1];
    }

    public static String getDimKeyName(Entity entity) {
        return DimensionHelper.getDimKeyName(entity.m_9236_());
    }

    public static String getDimKeyName(@Nullable Level world) {
        if (world != null) {
            return DimensionHelper.getDimKeyName((ResourceKey<Level>)world.m_46472_());
        }
        return "minecraft:overworld";
    }

    public static String getDimKeyName(ResourceKey<Level> dimensionKey) {
        return dimensionKey.m_135782_().toString();
    }

    public static ResourceKey<Level> getDimension(Entity entity) {
        return DimensionHelper.getDimension(entity.m_9236_());
    }

    public static ResourceKey<Level> getDimension(Level world) {
        return world.m_46472_();
    }

    public static DimensionType getDimTypeForName(String dimName) {
        return DimensionHelper.getDimTypeMap().get(dimName);
    }

    public static DimensionType getDimTypeForKey(ResourceKey<Level> dimKey) {
        return DimensionHelper.getDimTypeMap().get(DimensionHelper.getDimName(dimKey));
    }

    public static String getSafeDimName(ResourceKey<Level> dim) {
        return dim.m_135782_().toString().replaceAll(":", "~");
    }

    public static ResourceLocation getDimResource(String dimName) {
        return new ResourceLocation(dimName);
    }

    public static boolean isNetherWorld(Level world) {
        return world.m_46472_().equals((Object)Level.f_46429_);
    }

    public static boolean isOverworldWorld(Level world) {
        return world.m_46472_().equals((Object)Level.f_46428_);
    }

    public static boolean isEndWorld(Level world) {
        return world.m_46472_().equals((Object)Level.f_46430_);
    }

    public static ResourceKey<Level> getWorldKeyForName(String dimName) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionHelper.getDimResource(dimName));
    }

    public static Map<String, DimensionType> getDimTypeMap() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(LoaderHooks.getServer().m_129785_().iterator(), 16), false).collect(Collectors.toMap(DimensionHelper::getDimKeyName, Level::m_6042_));
    }

    public static List<ResourceKey<Level>> getServerDimNameList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(LoaderHooks.getServer().m_129785_().iterator(), 16), false).map(Level::m_46472_).collect(Collectors.toList());
    }

    public static Set<ResourceKey<Level>> getClientDimList() {
        return Minecraft.m_91087_().f_91074_.f_108617_.m_105151_();
    }
}

