/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.shulker;

import java.util.List;
import java.util.stream.IntStream;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlock;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class EnderiteShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)45, (Object)ItemStack.f_41583_);
    private int viewerCount;
    private AnimationStage animationStage = AnimationStage.CLOSED;
    private float animationProgress;
    private float prevAnimationProgress;

    public EnderiteShulkerBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EnderiteShulkerBoxBlockEntity be) {
        be.tick2();
    }

    public void tick2() {
        this.updateAnimation();
        if (this.animationStage == AnimationStage.OPENING || this.animationStage == AnimationStage.CLOSING) {
            this.pushEntities();
        }
    }

    protected void updateAnimation() {
        this.prevAnimationProgress = this.animationProgress;
        switch (this.animationStage) {
            case CLOSED: {
                this.animationProgress = 0.0f;
                break;
            }
            case OPENING: {
                this.animationProgress += 0.1f;
                if (!(this.animationProgress >= 1.0f)) break;
                this.pushEntities();
                this.animationStage = AnimationStage.OPENED;
                this.animationProgress = 1.0f;
                this.updateNeighborStates();
                break;
            }
            case CLOSING: {
                this.animationProgress -= 0.1f;
                if (!(this.animationProgress <= 0.0f)) break;
                this.animationStage = AnimationStage.CLOSED;
                this.animationProgress = 0.0f;
                this.updateNeighborStates();
                break;
            }
            case OPENED: {
                this.animationProgress = 1.0f;
            }
        }
    }

    public AnimationStage getAnimationStage() {
        return this.animationStage;
    }

    public AABB getBoundingBox(BlockState state) {
        return this.getBoundingBox((Direction)state.m_61143_((Property)EnderiteShulkerBoxBlock.f_56183_));
    }

    public AABB getBoundingBox(Direction openDirection) {
        float f = this.getAnimationProgress(1.0f);
        return Shapes.m_83144_().m_83215_().m_82363_((double)(0.5f * f * (float)openDirection.m_122429_()), (double)(0.5f * f * (float)openDirection.m_122430_()), (double)(0.5f * f * (float)openDirection.m_122431_()));
    }

    private AABB getCollisionBox(Direction facing) {
        Direction direction = facing.m_122424_();
        return this.getBoundingBox(facing).m_82310_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
    }

    private void pushEntities() {
        Direction direction;
        AABB box;
        List list;
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        if (blockState.m_60734_() instanceof EnderiteShulkerBoxBlock && !(list = this.f_58857_.m_45933_((Entity)null, box = this.getCollisionBox(direction = (Direction)blockState.m_61143_((Property)EnderiteShulkerBoxBlock.f_56183_)).m_82338_(this.f_58858_))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                double d = 0.0;
                double e = 0.0;
                double f = 0.0;
                AABB box2 = entity.m_20191_();
                switch (direction.m_122434_()) {
                    case X: {
                        d = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? box.f_82291_ - box2.f_82288_ : box2.f_82291_ - box.f_82288_;
                        d += 0.01;
                        break;
                    }
                    case Y: {
                        e = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? box.f_82292_ - box2.f_82289_ : box2.f_82292_ - box.f_82289_;
                        e += 0.01;
                        break;
                    }
                    case Z: {
                        f = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? box.f_82293_ - box2.f_82290_ : box2.f_82293_ - box.f_82290_;
                        f += 0.01;
                    }
                }
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3(d * (double)direction.m_122429_(), e * (double)direction.m_122430_(), f * (double)direction.m_122431_()));
            }
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7531_(int type, int data) {
        if (type == 1) {
            this.viewerCount = data;
            if (data == 0) {
                this.animationStage = AnimationStage.CLOSING;
                this.updateNeighborStates();
            }
            if (data == 1) {
                this.animationStage = AnimationStage.OPENING;
                this.updateNeighborStates();
            }
            return true;
        }
        return super.m_7531_(type, data);
    }

    private void updateNeighborStates() {
        this.m_58900_().m_60701_((LevelAccessor)this.m_58904_(), this.m_58899_(), 3);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.viewerCount < 0) {
                this.viewerCount = 0;
            }
            ++this.viewerCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.viewerCount);
            if (this.viewerCount == 1) {
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.viewerCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.viewerCount);
            if (this.viewerCount <= 0) {
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.enderitemod.enderiteShulkerBox");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.deserializeInventory(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)false);
        }
    }

    public void deserializeInventory(CompoundTag tag) {
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag) && tag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        }
    }

    public CompoundTag serializeInventory(CompoundTag tag) {
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)false);
        }
        return tag;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    public int[] m_7071_(Direction side) {
        return AVAILABLE_SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return !(Block.m_49814_((Item)stack.m_41720_()) instanceof EnderiteShulkerBoxBlock) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public float getAnimationProgress(float f) {
        return Mth.m_14179_((float)f, (float)this.prevAnimationProgress, (float)this.animationProgress);
    }

    public AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return new EnderiteShulkerBoxScreenHandler(syncId, playerInventory, (Container)this);
    }

    public boolean suffocates() {
        return this.animationStage == AnimationStage.CLOSED;
    }

    public static enum AnimationStage {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

