/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import net.enderitemc.enderitemod.tools.EnderiteShield;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class EnderiteShieldPlayerEntityMixin
extends LivingEntity {
    protected EnderiteShieldPlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract void m_36246_(Stat<?> var1);

    @Shadow
    public abstract ItemCooldowns m_36335_();

    @Inject(at={@At(value="HEAD")}, method={"damageShield"})
    private void damageIt(float amount, CallbackInfo info) {
        if (this.f_20935_.m_41720_() instanceof EnderiteShield) {
            if (!this.m_9236_().f_46443_) {
                this.m_36246_(Stats.f_12982_.m_12902_((Object)this.f_20935_.m_41720_()));
            }
            if (amount >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)amount);
                InteractionHand hand = this.m_7655_();
                this.f_20935_.m_41622_(i, (LivingEntity)this, playerEntity -> playerEntity.m_21190_(hand));
                if (this.f_20935_.m_41619_()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    this.f_20935_ = ItemStack.f_41583_;
                    this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"takeShieldHit"})
    private void portIt(LivingEntity attacker, CallbackInfo info) {
        if (this.m_6144_() && this.f_20935_.m_41720_() instanceof EnderiteShield && !this.m_36335_().m_41519_(this.f_20935_.m_41720_())) {
            int charge = 0;
            if (this.f_20935_.m_41783_().m_128441_("teleport_charge")) {
                charge = Integer.parseInt(this.f_20935_.m_41783_().m_128423_("teleport_charge").m_7916_());
            }
            if (!(this.m_9236_().f_46443_ || charge <= 0 || attacker instanceof EnderDragon || attacker instanceof WitherBoss || attacker instanceof ElderGuardian)) {
                double d = attacker.m_20185_();
                double e = attacker.m_20186_();
                double f = attacker.m_20189_();
                double yaw = this.f_20885_;
                double pitch = this.m_146909_();
                double temp = Math.cos(Math.toRadians(pitch));
                double dX = temp * -Math.sin(Math.toRadians(yaw));
                double dY = -Math.sin(Math.toRadians(pitch));
                double dZ = temp * Math.cos(Math.toRadians(yaw));
                double distance = 10.0;
                for (int i = 0; i < 16; ++i) {
                    double g = attacker.m_20185_() + dX * distance + (attacker.m_217043_().m_188500_() - 0.5) * 16.0;
                    double h = Mth.m_14008_((double)(attacker.m_20186_() + dY * distance + (double)(attacker.m_217043_().m_188503_(16) - 8)), (double)0.0, (double)(this.m_9236_().m_141928_() - 1));
                    double j = attacker.m_20189_() + dZ * distance + (attacker.m_217043_().m_188500_() - 0.5) * 16.0;
                    if (attacker.m_20159_()) {
                        attacker.m_8127_();
                    }
                    if (!attacker.m_20984_(g, h, j, true)) continue;
                    SoundEvent soundEvent = attacker instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                    this.m_9236_().m_6263_((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    attacker.m_5496_(soundEvent, 1.0f, 1.0f);
                    this.f_20935_.m_41783_().m_128405_("teleport_charge", charge - 1);
                    this.m_36335_().m_41524_(this.f_20935_.m_41720_(), 128);
                    break;
                }
            }
        }
    }
}

