/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.forge;

import com.misterpemodder.shulkerboxtooltip.api.forge.ShulkerBoxTooltipPlugin;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.config.ClothConfig;
import net.enderitemc.enderitemod.forge.init.AnimationFeatures;
import net.enderitemc.enderitemod.forge.item.EnderiteShieldForge;
import net.enderitemc.enderitemod.forge.tools.EnderiteElytraChestplate;
import net.enderitemc.enderitemod.forge.tools.EnderiteElytraSeperated;
import net.enderitemc.enderitemod.materials.EnderiteArmorMaterial;
import net.enderitemc.enderitemod.misc.EnderiteElytraFeatureRender;
import net.enderitemc.enderitemod.modIntegrations.ShulkerBoxTooltipApiImplementation;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntity;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntityRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enderitemod")
public class EnderiteModForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RegistrySupplier<Item> ENDERITE_ELYTRA = EnderiteMod.ITEMS.register("enderite_elytra", () -> new EnderiteElytraChestplate(EnderiteArmorMaterial.ENDERITE, ArmorItem.Type.CHESTPLATE, EnderiteMod.ENDERITE_ELYTRA_ITEM_SETTINGS));
    public static final RegistrySupplier<Item> ENDERITE_ELYTRA_SEPERATED = EnderiteMod.ITEMS.register("enderite_elytra_seperated", () -> new EnderiteElytraSeperated(EnderiteMod.ENDERITE_ELYTRA_SEPERATED_ITEM_SETTINGS));
    public static final RegistrySupplier<BlockEntityType<EnderiteShulkerBoxBlockEntity>> ENDERITE_SHULKER_BOX_BLOCK_ENTITY = EnderiteMod.BLOCK_ENTITY_TYPES.register("enderite_shulker_box_block_entity", () -> BlockEntityType.Builder.m_155273_(EnderiteShulkerBoxBlockEntity::new, (Block[])new Block[]{(Block)EnderiteMod.ENDERITE_SHULKER_BOX.get()}).m_58966_(null));
    public static final RegistrySupplier<Item> ENDERITE_SHIELD_FORGE = EnderiteMod.ITEMS.register("enderite_shield", () -> new EnderiteShieldForge(EnderiteMod.ENDERITE_SHIELD_ITEM_SETTINGS));

    public EnderiteModForge() {
        EventBuses.registerModEventBus((String)"enderitemod", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        EnderiteMod.init();
        EnderiteMod.ENDERITE_ELYTRA = ENDERITE_ELYTRA;
        EnderiteMod.ENDERITE_ELYTRA_SEPERATED = ENDERITE_ELYTRA_SEPERATED;
        EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY = ENDERITE_SHULKER_BOX_BLOCK_ENTITY;
        EnderiteMod.ENDERITE_SHIELD = ENDERITE_SHIELD_FORGE;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        DispenserBlock.m_52672_((ItemLike)((Block)EnderiteMod.ENDERITE_SHULKER_BOX.get()).m_5456_(), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)((Item)EnderiteMod.ENDERITE_SHEAR.get()).m_5456_(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="enderitemod")
    public static class RegistryEventsClient {
        @SubscribeEvent
        public static void loadCompleteEvent(FMLLoadCompleteEvent event) {
            AnimationFeatures.init();
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY.get()), EnderiteShulkerBoxBlockEntityRenderer::new);
            if (ModList.get().isLoaded("cloth_config")) {
                ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ClothConfig((Screen)screen).getScreen()));
            }
            if (ModList.get().isLoaded("shulkerboxtooltip")) {
                ModLoadingContext.get().registerExtensionPoint(ShulkerBoxTooltipPlugin.class, () -> new ShulkerBoxTooltipPlugin(ShulkerBoxTooltipApiImplementation::new));
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void renderPlayer(EntityRenderersEvent.AddLayers event) {
            LivingEntityRenderer renderer = event.getSkin("default");
            EnderiteElytraFeatureRender layer = new EnderiteElytraFeatureRender(renderer, event.getEntityModels());
            if (renderer != null) {
                renderer.m_115326_(layer);
            } else {
                LOGGER.error("Couldn't get renderer");
            }
            renderer = event.getSkin("slim");
            layer = new EnderiteElytraFeatureRender(renderer, event.getEntityModels());
            if (renderer != null) {
                renderer.m_115326_(layer);
            } else {
                LOGGER.error("Couldn't get renderer");
            }
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20529_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20501_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20530_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20524_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20458_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20481_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20497_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20562_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20511_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20512_);
            RegistryEventsClient.addEntityLayer(event, EntityType.f_20531_);
        }

        private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<T, M>> void addEntityLayer(EntityRenderersEvent.AddLayers evt, EntityType<? extends T> entityType) {
            LivingEntityRenderer renderer = evt.getRenderer(entityType);
            if (renderer != null) {
                renderer.m_115326_(new EnderiteElytraFeatureRender(renderer, evt.getEntityModels()));
            }
        }
    }
}

