/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AdditionalTableModifier
extends LootModifier {
    public static final Supplier<Codec<AdditionalTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AdditionalTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.fieldOf("tableRef").forGetter(o -> o.tableID), (App)Codec.FLOAT.fieldOf("referChance").forGetter(o -> Float.valueOf(o.referChance)))).apply((Applicative)instance, AdditionalTableModifier::new)));
    private String tableID;
    private final LootTableReference reference;
    private final float referChance;

    protected AdditionalTableModifier(LootItemCondition[] conditionsIn, String tableID, float chanceToRefer) {
        super(conditionsIn);
        this.referChance = chanceToRefer;
        this.tableID = tableID;
        this.reference = (LootTableReference)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(tableID)).m_7512_();
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188501_() <= this.referChance) {
            ObjectArrayList items = new ObjectArrayList();
            this.reference.m_6948_(arg_0 -> ((ObjectArrayList)items).add(arg_0), context);
            return items;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

