/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.api.crafting.condition.TypeDisabledCondition;
import com.oblivioussp.spartanweaponry.item.crafting.ITagCookingRecipe;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TagCookingRecipeSerializer<T extends ITagCookingRecipe>
implements RecipeSerializer<T> {
    private final RecipeFactory<T> factory;
    private final int defaultCookingTime;

    public TagCookingRecipeSerializer(RecipeFactory<T> factoryIn, int defaultCookingTimeIn) {
        this.factory = factoryIn;
        this.defaultCookingTime = defaultCookingTimeIn;
    }

    public T fromJson(ResourceLocation idIn, JsonObject jsonIn, ICondition.IContext context) {
        JsonArray disabledTypesArray = GsonHelper.m_13832_((JsonObject)jsonIn, (String)"disabled_types", (JsonArray)new JsonArray());
        for (JsonElement disabledType : disabledTypesArray) {
            String type = disabledType.getAsString();
            if (!TypeDisabledCondition.disabledRecipeTypes.contains(type)) continue;
            return null;
        }
        ResourceLocation resultLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonIn, (String)"result_tag"));
        TagKey tagResult = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)resultLocation);
        if (context.getTag(tagResult).isEmpty()) {
            Log.info("Empty result tag:\"" + resultLocation + "\" Skipping...");
            return null;
        }
        String group = GsonHelper.m_13851_((JsonObject)jsonIn, (String)"group", (String)"");
        CookingBookCategory category = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonIn, (String)"category", (String)""), (Enum)CookingBookCategory.MISC);
        JsonObject ingredientJson = GsonHelper.m_13885_((JsonObject)jsonIn, (String)"ingredient") ? this.checkJsonArray(jsonIn, "ingredient") : GsonHelper.m_13930_((JsonObject)jsonIn, (String)"ingredient");
        Ingredient ingredientInput = Ingredient.m_43917_((JsonElement)ingredientJson);
        float experience = GsonHelper.m_13820_((JsonObject)jsonIn, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13824_((JsonObject)jsonIn, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(idIn, group, category, ingredientInput, Ingredient.m_204132_((TagKey)tagResult), experience, cookingTime);
    }

    public JsonElement checkJsonArray(JsonObject jsonIn, String nameIn) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)jsonIn, (String)nameIn);
        JsonArray result = new JsonArray();
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            String disableType = GsonHelper.m_13906_((JsonObject)object, (String)"disabled_type");
            if (TypeDisabledCondition.disabledRecipeTypes.contains(disableType)) continue;
            object.remove("disabled_type");
            result.add((JsonElement)object);
        }
        return result;
    }

    @Nullable
    public T fromNetwork(ResourceLocation idIn, FriendlyByteBuf bufferIn) {
        String group = bufferIn.m_130277_();
        CookingBookCategory category = (CookingBookCategory)bufferIn.m_130066_(CookingBookCategory.class);
        Ingredient ingredientInput = Ingredient.m_43940_((FriendlyByteBuf)bufferIn);
        Ingredient ingredientOutput = Ingredient.m_43940_((FriendlyByteBuf)bufferIn);
        float experience = bufferIn.readFloat();
        int cookingTime = bufferIn.m_130242_();
        return this.factory.create(idIn, group, category, ingredientInput, ingredientOutput, experience, cookingTime);
    }

    public void toNetwork(FriendlyByteBuf bufferIn, T recipeIn) {
        bufferIn.m_130070_(recipeIn.m_6076_());
        bufferIn.m_130068_((Enum)recipeIn.getCategory());
        recipeIn.getInputIngredient().m_43923_(bufferIn);
        recipeIn.getResultIngredient().m_43923_(bufferIn);
        bufferIn.writeFloat(recipeIn.getExperienceDrop());
        bufferIn.m_130130_(recipeIn.getCookTime());
    }

    public T fromJson(ResourceLocation idIn, JsonObject jsonIn) {
        return null;
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends ITagCookingRecipe> {
        public T create(ResourceLocation var1, String var2, CookingBookCategory var3, Ingredient var4, Ingredient var5, float var6, int var7);
    }
}

