/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;

public class QuiverUpgradeRecipe
extends SmithingTransformRecipe {
    public QuiverUpgradeRecipe(ResourceLocation recipeId, Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        super(recipeId, template, base, addition, result);
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccessIn) {
        ItemStack origOutputStack = this.m_8043_(registryAccessIn);
        ItemStack outputStack = super.m_5874_(inv, registryAccessIn);
        outputStack.getCapability(ModCapabilities.QUIVER_ITEM_CAPABILITY).ifPresent(itemHandler -> itemHandler.resize(origOutputStack.m_41698_("Ammo").m_128451_("Size")));
        return outputStack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.QUIVER_UPGRADE_SMITHING.get();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public static class Serializer
    implements RecipeSerializer<QuiverUpgradeRecipe> {
        public QuiverUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient templateIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"template"));
            Ingredient baseIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient additionIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new QuiverUpgradeRecipe(recipeId, templateIngredient, baseIngredient, additionIngredient, resultStack);
        }

        public QuiverUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient templateIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                Ingredient baseIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                Ingredient additionIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ItemStack resultStack = buffer.m_130267_();
                return new QuiverUpgradeRecipe(recipeId, templateIngredient, baseIngredient, additionIngredient, resultStack);
            }
            catch (Exception e) {
                Log.error("Failed to read a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, QuiverUpgradeRecipe recipe) {
            try {
                RecipeSerializer.f_266093_.m_6178_(buffer, (Recipe)recipe);
            }
            catch (Exception e) {
                Log.error("Failed to write a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }
    }
}

