/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.List;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReloadResourceEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onUpdateTags(TagsUpdatedEvent ev) {
        List<IReloadable> reloadList = ReloadableHandler.getReloadList();
        Log.debug("Initaliasing reloadables for " + reloadList.size() + " values");
        long start = System.nanoTime();
        reloadList.forEach(item -> item.reload());
        long end = System.nanoTime();
        double milliseconds = (double)(end - start) / 1000000.0;
        Log.info("Finished initialising Weapon Traits & Attributes! Took " + milliseconds + "ms");
    }
}

