/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.mojang.datafixers.util.Either;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.client.KeyBinds;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.inventory.tooltip.OilCoatingTooltip;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.network.QuiverAccessPacket;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onMouseEvent(InputEvent.MouseButton ev) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91080_ != null || mc.m_91104_()) {
            return;
        }
        if (ev.getButton() == KeyBinds.KEY_ACCESS_QUIVER.getKey().m_84873_() && ev.getAction() == 1) {
            NetworkHandler.sendPacketToServer(new QuiverAccessPacket());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onKeyEvent(InputEvent.Key ev) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91080_ != null || mc.m_91104_()) {
            return;
        }
        if (ev.getKey() == KeyBinds.KEY_ACCESS_QUIVER.getKey().m_84873_() && ev.getAction() == 1) {
            NetworkHandler.sendPacketToServer(new QuiverAccessPacket());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents ev) {
        ItemStack stack = ev.getItemStack();
        if (stack.m_204117_(ModItemTags.OILABLE_WEAPONS)) {
            LazyOptional handler = stack.getCapability(ModCapabilities.OIL_CAPABILITY);
            handler.ifPresent(oilHandler -> {
                if (oilHandler.isOiled()) {
                    OilEffect oilEffect = oilHandler.getEffect().get();
                    Optional<Potion> potionOpt = oilHandler.getPotion();
                    ItemStack oilStack = potionOpt.isPresent() ? OilHelper.makePotionOilStack(potionOpt.get()) : OilHelper.makeOilStack(oilEffect);
                    ev.getTooltipElements().add(1, Either.right((Object)new OilCoatingTooltip(oilStack, oilHandler.getUsesLeft(), oilEffect.getMaxUses())));
                } else {
                    ev.getTooltipElements().add(1, Either.left((Object)Component.m_237115_((String)"tooltip.spartanweaponry.oilable").m_130940_(ChatFormatting.BLUE)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre ev) {
        Minecraft mc = Minecraft.m_91087_();
        if (ev.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() && mc.f_91074_.m_21205_().m_204117_(ModItemTags.HAS_CUSTOM_CROSSHAIR)) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent ev) {
        ItemStack stack = ev.getItemStack();
        if (!FMLLoader.isProduction() && stack.m_41782_() && ev.getFlags().m_7050_()) {
            String nbtStr = stack.m_41783_().toString();
            ev.getToolTip().add(Component.m_237113_((String)("NBT: " + ChatFormatting.DARK_GRAY + nbtStr)).m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }
}

