/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModDamageTypes;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModParticles;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ThrowingWeaponEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    public static final String NBT_WEAPON = "Weapon";
    protected static final EntityDataAccessor<ItemStack> DATA_WEAPON = SynchedEntityData.m_135353_(ThrowingWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Byte> DATA_RETURN = SynchedEntityData.m_135353_(ThrowingWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int ticksInAir = 0;
    protected float waterInertia = 0.0f;
    protected boolean isReturning = false;
    protected boolean playedReturnSound = false;

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, Level level) {
        super(type, level);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, Level level, double x, double y, double z) {
        super(type, x, y, z, level);
    }

    public ThrowingWeaponEntity(EntityType<? extends ThrowingWeaponEntity> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    public ThrowingWeaponEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.THROWING_WEAPON.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_WEAPON, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_RETURN, (Object)0);
    }

    protected ItemStack m_7941_() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_WEAPON);
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public void m_8119_() {
        byte returnLevel;
        Level level = this.m_9236_();
        if (this.waterInertia == 0.0f) {
            this.waterInertia = this.getWeaponItem().getEnchantmentLevel((Enchantment)ModEnchantments.HYDRODYNAMIC.get()) == 1 ? 0.98f : -1.0f;
        }
        Entity thrower = this.m_19749_();
        if ((this.f_36704_ > 4 || this.isReturning) && thrower != null && (returnLevel = ((Byte)this.m_20088_().m_135370_(DATA_RETURN)).byteValue()) > 0) {
            if (!(thrower == null || !thrower.m_6084_() || thrower instanceof ServerPlayer && thrower.m_5833_())) {
                if (!this.isReturning) {
                    this.m_36790_(true);
                    this.f_36703_ = false;
                    this.isReturning = true;
                    this.m_20242_(true);
                }
                Vec3 distance = new Vec3(thrower.m_20185_() - this.m_20185_(), thrower.m_20188_() - this.m_20186_(), thrower.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + distance.f_82480_ * 0.015 * (double)returnLevel, this.m_20189_());
                if (level.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double velocity = 1.0 + 0.25 * (double)returnLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(distance.m_82541_().m_82490_(velocity)));
                if (!this.playedReturnSound) {
                    this.m_5496_((SoundEvent)ModSounds.THROWING_WEAPON_LOYALTY_RETURN.get(), 10.0f, 1.0f);
                    this.playedReturnSound = true;
                }
            } else if (returnLevel > 0 && !thrower.m_6084_()) {
                this.m_36790_(false);
                this.isReturning = false;
                this.m_20242_(false);
                this.m_20088_().m_135381_(DATA_RETURN, (Object)0);
            }
        }
        super.m_8119_();
        if (!this.f_36703_) {
            ++this.ticksInAir;
        } else if (this.ticksInAir != 0) {
            this.ticksInAir = 0;
        }
    }

    protected void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= 1200) {
            this.dropAsItem();
            this.m_146870_();
        }
    }

    public int m_6078_() {
        return 100;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        Entity shooter = this.m_19749_();
        Level level = this.m_9236_();
        if (entity != null) {
            boolean isEnderman;
            Player player;
            ItemStack weapon = this.getWeaponItem();
            float damage = Mth.m_14165_((double)this.m_36789_());
            if (this.m_36792_()) {
                damage += (float)this.f_19796_.m_188503_((int)damage / 2 + 2);
            }
            if (shooter != null && (this.canBeCaughtInMidair(shooter, entity) || this.isReturning) && entity instanceof Player && this.attemptCatch(player = (Player)entity)) {
                return;
            }
            DamageSource src = shooter == null ? ModDamageTypes.thrownWeaponMob((Entity)this, (Entity)this) : (shooter instanceof Player ? ModDamageTypes.thrownWeaponPlayer((Entity)this, shooter) : ModDamageTypes.thrownWeaponMob((Entity)this, shooter));
            if (entity instanceof LivingEntity && shooter instanceof LivingEntity) {
                IOilHandler oilHandler;
                if (weapon.m_41720_() instanceof IWeaponTraitContainer && !entity.m_7306_(shooter)) {
                    IWeaponTraitContainer container = (IWeaponTraitContainer)weapon.m_41720_();
                    WeaponMaterial material = container.getMaterial();
                    Collection<WeaponTrait> traits = container.getAllWeaponTraits();
                    for (WeaponTrait trait : traits) {
                        Optional<IMeleeTraitCallback> opt = trait.getMeleeCallback();
                        if (!opt.isPresent()) continue;
                        IMeleeTraitCallback callback = opt.get();
                        damage = callback.modifyDamageDealt(material, damage, src, (LivingEntity)shooter, (LivingEntity)entity);
                        callback.onHitEntity(container.getMaterial(), weapon, (LivingEntity)entity, (LivingEntity)shooter, (Entity)this);
                    }
                }
                if (weapon.m_204117_(ModItemTags.OILABLE_WEAPONS) && (oilHandler = (IOilHandler)weapon.getCapability(ModCapabilities.OIL_CAPABILITY).resolve().get()).isOiled()) {
                    float dmgUnmodified = damage;
                    if ((damage = oilHandler.useEffect(damage, level, (LivingEntity)entity, (LivingEntity)shooter, weapon)) != dmgUnmodified && !level.m_5776_()) {
                        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.OIL_DAMAGE_BOOSTED.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 8, 0.2, 0.2, 0.2, 0.5);
                    }
                }
            }
            boolean bl = isEnderman = entity.m_6095_() == EntityType.f_20566_;
            if (this.m_6060_() && !isEnderman) {
                entity.m_20254_(5);
            }
            if (entity.m_6469_(src, damage)) {
                if (weapon.m_41763_() && weapon.m_220157_(1, this.f_19796_, null)) {
                    this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    level.m_7605_((Entity)this, (byte)3);
                    this.m_146870_();
                }
                if (entity instanceof LivingEntity) {
                    Vec3 knockVec;
                    LivingEntity entitylivingbase = (LivingEntity)entity;
                    if (this.m_150123_() > 0 && (knockVec = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6)).m_82556_() > 0.0) {
                        entitylivingbase.m_5997_(knockVec.f_82479_, 0.1, knockVec.f_82481_);
                    }
                    if (!level.f_46443_ && shooter instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)entitylivingbase, (Entity)shooter);
                        EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)shooter), (Entity)entitylivingbase);
                    }
                    this.m_7761_(entitylivingbase);
                    if (shooter != null && entitylivingbase != shooter && entitylivingbase instanceof Player && shooter instanceof ServerPlayer) {
                        ((ServerPlayer)shooter).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
                this.m_5496_(this.getMobHitSound(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                if (!isEnderman) {
                    this.m_20256_(this.m_20184_().m_82490_(-0.1));
                    this.m_146922_(this.m_146908_() + 180.0f);
                    this.f_19859_ += 180.0f;
                }
            } else {
                this.m_20256_(this.m_20184_().m_82490_(-0.1));
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_19859_ += 180.0f;
                this.ticksInAir = 0;
                if (!level.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                    if ((Byte)this.m_20088_().m_135370_(DATA_RETURN) > 0 && !this.m_36797_()) {
                        this.m_36790_(true);
                    } else if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                        this.dropAsItem();
                        this.m_146870_();
                    }
                }
            }
        } else {
            super.m_5790_(hitResult);
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        Level level = this.m_9236_();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            if (!level.f_46443_) {
                BlockState state = level.m_8055_(hitResult.m_82425_());
                ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(hitResult.m_82425_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            ItemStack stack = this.getWeaponItem();
            this.removeEnchantments(stack);
        }
        super.m_8060_(hitResult);
    }

    protected void removeEnchantments(ItemStack stack) {
        Level level = this.m_9236_();
        if (stack.m_41793_() && stack.m_41784_().m_128441_("AmmoUsed")) {
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of(), (ItemStack)stack);
            if (!level.f_46443_) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.1, 0.1, 0.1, 0.2);
            }
        }
    }

    protected void dropAsItem() {
        ItemStack stack = this.getWeaponItem();
        this.removeEnchantments(stack);
        this.m_5552_(stack, 0.1f);
    }

    public void m_6123_(Player entityIn) {
        if (this.f_36703_ || this.isReturning) {
            this.attemptCatch(entityIn);
        }
    }

    protected float m_6882_() {
        return this.waterInertia > 0.0f ? this.waterInertia : super.m_6882_();
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)ModSounds.THROWN_WEAPON_HIT_GROUND.get();
    }

    protected SoundEvent getMobHitSound() {
        return (SoundEvent)ModSounds.THROWN_WEAPON_HIT_MOB.get();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.getWeaponItem(), false);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setWeapon(additionalData.m_130267_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getWeaponItem() {
        return this.m_7941_();
    }

    public boolean isValidThrowingWeapon() {
        return !this.getWeaponItem().m_41619_();
    }

    public void setWeapon(ItemStack weaponStack) {
        ItemStack stack = weaponStack.m_41777_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof ThrowingWeaponItem) {
            int maxAmmo = ((ThrowingWeaponItem)stack.m_41720_()).getMaxAmmo(stack);
            stack.m_41784_().m_128405_("AmmoUsed", maxAmmo - 1);
            stack.m_41783_().m_128379_("Original", false);
        }
        this.m_20088_().m_135381_(DATA_WEAPON, (Object)stack);
        this.m_20088_().m_135381_(DATA_RETURN, (Object)((byte)stack.getEnchantmentLevel(Enchantments.f_44955_)));
    }

    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter == entityHit && this.m_36797_();
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }

    protected boolean attemptCatch(Player player) {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.f_36706_ <= 0) {
            boolean canBePickedUp;
            boolean bl = canBePickedUp = this.f_36705_ == AbstractArrow.Pickup.ALLOWED || this.f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && player.m_150110_().f_35937_;
            if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                boolean pickUpAsNewItem = true;
                ItemStack weapon = this.getWeaponItem();
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ThrowingWeaponItem throwingWeapon;
                    int maxAmmo;
                    int currentAmmo;
                    Item item;
                    ItemStack slotStack = player.m_150109_().m_8020_(i);
                    if (slotStack.m_41720_() != weapon.m_41720_() || !weapon.m_41784_().m_128403_("UUID") || !slotStack.m_41784_().m_128403_("UUID") || !weapon.m_41783_().m_128342_("UUID").equals(slotStack.m_41783_().m_128342_("UUID")) || !((item = weapon.m_41720_()) instanceof ThrowingWeaponItem) || (currentAmmo = (maxAmmo = (throwingWeapon = (ThrowingWeaponItem)item).getMaxAmmo(slotStack)) - slotStack.m_41783_().m_128451_("AmmoUsed")) >= maxAmmo) continue;
                    int itemDamage = slotStack.m_41773_() + weapon.m_41773_();
                    if (itemDamage > slotStack.m_41776_()) {
                        itemDamage -= slotStack.m_41776_() + 1;
                    } else {
                        slotStack.m_41783_().m_128405_("AmmoUsed", maxAmmo - ++currentAmmo);
                    }
                    slotStack.m_41721_(itemDamage);
                    pickUpAsNewItem = false;
                    canBePickedUp = true;
                    break;
                }
                if (pickUpAsNewItem) {
                    ItemStack pickUpStack = weapon.m_41777_();
                    this.removeEnchantments(pickUpStack);
                    canBePickedUp = player.m_150109_().m_36054_(pickUpStack);
                }
            }
            if (canBePickedUp) {
                player.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
            return canBePickedUp;
        }
        return false;
    }
}

