/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.data.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.item.crafting.ITagCookingRecipe;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class TagCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory recipeCategory;
    private final CookingBookCategory cookingBookCategory;
    private final ImmutableMap<String, Item> ingredientMap;
    private final TagKey<Item> resultTag;
    private final float experience;
    private final int cookingTime;
    private final ImmutableList.Builder<String> disabledTypesBuilder;
    private final RecipeSerializer<? extends ITagCookingRecipe> serializer;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_285878_();
    @Nullable
    private String group;

    private TagCookingRecipeBuilder(RecipeCategory recipeCategoryIn, CookingBookCategory cookingBookCategoryIn, ImmutableMap<String, Item> ingredientMapIn, TagKey<Item> resultTagIn, float experienceIn, int cookingTimeIn, RecipeSerializer<? extends ITagCookingRecipe> serializerIn) {
        this.recipeCategory = recipeCategoryIn;
        this.cookingBookCategory = cookingBookCategoryIn;
        this.ingredientMap = ingredientMapIn;
        this.resultTag = resultTagIn;
        this.experience = experienceIn;
        this.cookingTime = cookingTimeIn;
        this.serializer = serializerIn;
        this.disabledTypesBuilder = new ImmutableList.Builder();
    }

    public static TagCookingRecipeBuilder smelting(ImmutableMap<String, Item> ingredientMapIn, RecipeCategory recipeCategoryIn, TagKey<Item> resultTagIn, float experienceIn, int cookingTimeIn) {
        return new TagCookingRecipeBuilder(recipeCategoryIn, CookingBookCategory.MISC, ingredientMapIn, resultTagIn, experienceIn, cookingTimeIn, (RecipeSerializer<? extends ITagCookingRecipe>)((RecipeSerializer)ModRecipeSerializers.TAGGED_SMELTING.get()));
    }

    public static TagCookingRecipeBuilder blasting(ImmutableMap<String, Item> ingredientMapIn, RecipeCategory recipeCategoryIn, TagKey<Item> resultTagIn, float experienceIn, int cookingTimeIn) {
        return new TagCookingRecipeBuilder(recipeCategoryIn, CookingBookCategory.MISC, ingredientMapIn, resultTagIn, experienceIn, cookingTimeIn, (RecipeSerializer<? extends ITagCookingRecipe>)((RecipeSerializer)ModRecipeSerializers.TAGGED_BLASTING.get()));
    }

    public TagCookingRecipeBuilder unlockedBy(String nameIn, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(nameIn, criterionIn);
        return this;
    }

    public TagCookingRecipeBuilder group(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public TagCookingRecipeBuilder addDisabledTypes(String ... disableTypes) {
        this.disabledTypesBuilder.add((Object[])disableTypes);
        return this;
    }

    public Item m_142372_() {
        return Items.f_42127_;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation idIn) {
        this.advancementBuilder.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)idIn)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)idIn)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(idIn, this.group == null ? "" : this.group, this.cookingBookCategory, this.ingredientMap, this.resultTag, this.experience, this.cookingTime, (ImmutableList<String>)this.disabledTypesBuilder.build(), this.advancementBuilder, idIn.m_246208_("recipes/" + this.recipeCategory.m_247710_() + "/"), this.serializer));
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final CookingBookCategory cookingBookCategory;
        private final ImmutableMap<String, Item> ingredientMap;
        private final TagKey<Item> resultTag;
        private final float experience;
        private final int cookingTime;
        private final ImmutableList<String> disabledTypes;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends ITagCookingRecipe> serializer;

        public Result(ResourceLocation idIn, String groupIn, CookingBookCategory cookingBookCategoryIn, ImmutableMap<String, Item> ingredientMapIn, TagKey<Item> resultTagIn, float experienceIn, int cookingTimeIn, ImmutableList<String> disabledTypesIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn, RecipeSerializer<? extends ITagCookingRecipe> serializerIn) {
            this.id = idIn;
            this.group = groupIn;
            this.cookingBookCategory = cookingBookCategoryIn;
            this.ingredientMap = ingredientMapIn;
            this.resultTag = resultTagIn;
            this.experience = experienceIn;
            this.cookingTime = cookingTimeIn;
            this.disabledTypes = disabledTypesIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
            this.serializer = serializerIn;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("category", this.cookingBookCategory.m_7912_());
            JsonArray ingredientArray = new JsonArray();
            this.ingredientMap.forEach((disableType, item) -> {
                JsonObject entryObject = new JsonObject();
                entryObject.addProperty("item", ForgeRegistries.ITEMS.getKey(item).toString());
                entryObject.addProperty("disabled_type", disableType);
                ingredientArray.add((JsonElement)entryObject);
            });
            json.add("ingredient", (JsonElement)ingredientArray);
            json.addProperty("result_tag", this.resultTag.f_203868_().toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
            if (!this.disabledTypes.isEmpty()) {
                JsonArray disabledTypesArray = new JsonArray();
                for (String type : this.disabledTypes) {
                    disabledTypesArray.add(type);
                }
                json.add("disabled_types", (JsonElement)disabledTypesArray);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

