/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.compat.jei;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.item.crafting.OilBrewingRecipe;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JeiOilBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> baseOils;
    private final List<ItemStack> ingredients;
    private final ItemStack output;
    private final ResourceLocation uid;
    private int brewingSteps = Integer.MAX_VALUE;

    public JeiOilBrewingRecipe(List<ItemStack> baseOilsIn, List<ItemStack> ingredientsIn, ItemStack outputIn) {
        this.baseOils = ImmutableList.copyOf(baseOilsIn);
        this.ingredients = ImmutableList.copyOf(ingredientsIn);
        this.output = outputIn;
        ResourceLocation outputLocation = ForgeRegistries.ITEMS.getKey((Object)outputIn.m_41720_());
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        this.uid = new ResourceLocation(outputLocation.m_135827_(), outputLocation.m_135815_() + "." + registry.getKey((Object)OilHelper.getOilFromStack(outputIn)).m_135815_() + "_from_brewing");
    }

    public @Unmodifiable List<ItemStack> getPotionInputs() {
        return this.baseOils;
    }

    public @Unmodifiable List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getPotionOutput() {
        return this.output;
    }

    public int getBrewingSteps() {
        if (this.brewingSteps == Integer.MAX_VALUE) {
            OilEffect oilEffect = OilHelper.getOilFromStack(this.output);
            this.brewingSteps = OilBrewingRecipe.getBrewingSteps(oilEffect);
        }
        return this.brewingSteps;
    }

    @Nullable
    public ResourceLocation getUid() {
        return this.uid;
    }
}

