/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import com.oblivioussp.spartanweaponry.client.model.OilCoatingItemBakedModel;
import com.oblivioussp.spartanweaponry.util.Log;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class OilCoatedItemModel
implements IUnbakedGeometry<OilCoatedItemModel> {
    protected ImmutableList<Material> textures;
    protected Material coatingTexture;
    protected final Int2ObjectMap<ForgeFaceData> faceData;
    protected final Int2ObjectMap<ResourceLocation> renderTypeNames;

    public OilCoatedItemModel(@Nullable ImmutableList<Material> texturesIn, @Nullable Material coatingTextureIn, Int2ObjectMap<ForgeFaceData> faceDataIn, Int2ObjectMap<ResourceLocation> renderTypeNamesIn) {
        this.textures = texturesIn;
        this.coatingTexture = coatingTextureIn;
        this.faceData = faceDataIn;
        this.renderTypeNames = renderTypeNamesIn;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        RenderTypeGroup renderTypes;
        ResourceLocation renderTypeName;
        List bakedQuads;
        List unbakedElements;
        TextureAtlasSprite sprite;
        if (this.textures == null) {
            ImmutableList.Builder layerTextureBuilder = ImmutableList.builder();
            int i = 0;
            while (context.hasMaterial("layer" + i)) {
                layerTextureBuilder.add((Object)context.getMaterial("layer" + i));
                ++i;
            }
            if (context.hasMaterial("coating")) {
                this.coatingTexture = context.getMaterial("coating");
            }
            this.textures = layerTextureBuilder.build();
        }
        if (this.textures.size() <= 0) {
            throw new IllegalStateException("Couldn't resolve Textures for model: " + context.getModelName());
        }
        if (this.coatingTexture == null) {
            Log.error("Couldn't resolve Coating textures for model: " + context.getModelName());
        }
        TextureAtlasSprite particleSprite = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        Transformation transform = context.getRootTransform();
        if (!transform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)transform);
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        OilCoatingItemBakedModel.Builder builder = OilCoatingItemBakedModel.makeBuilder(context, particleSprite, overrides, context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            sprite = spriteGetter.apply((Material)this.textures.get(i));
            unbakedElements = UnbakedGeometryHelper.createUnbakedItemElements((int)i, (SpriteContents)sprite.m_245424_(), (ForgeFaceData)((ForgeFaceData)this.faceData.get(i)));
            bakedQuads = UnbakedGeometryHelper.bakeElements((List)unbakedElements, mat -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            renderTypeName = (ResourceLocation)this.renderTypeNames.get(i);
            renderTypes = renderTypeName != null ? context.getRenderType(renderTypeName) : normalRenderTypes;
            builder.addQuads(renderTypes, bakedQuads);
        }
        if (this.coatingTexture != null) {
            int coatingLayer = 100;
            sprite = spriteGetter.apply(this.coatingTexture);
            unbakedElements = UnbakedGeometryHelper.createUnbakedItemElements((int)100, (SpriteContents)sprite.m_245424_(), (ForgeFaceData)((ForgeFaceData)this.faceData.get(100)));
            bakedQuads = UnbakedGeometryHelper.bakeElements((List)unbakedElements, mat -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            renderTypeName = (ResourceLocation)this.renderTypeNames.get(100);
            renderTypes = renderTypeName != null ? context.getRenderType(renderTypeName) : normalRenderTypes;
            builder.addCoatedQuads(renderTypes, bakedQuads);
        }
        return builder.build();
    }

    public static class Loader
    implements IGeometryLoader<OilCoatedItemModel> {
        public static final Loader INSTANCE = new Loader();

        public OilCoatedItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            JsonObject jsonForgeData;
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = new ResourceLocation((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Duplicate render type for layer " + layer);
                    }
                }
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            if (jsonObject.has("forge_data") && (jsonForgeData = jsonObject.getAsJsonObject("forge_data")).has("layers")) {
                JsonObject jsonEmissiveLayers = jsonForgeData.getAsJsonObject("layers");
                for (Map.Entry entry : jsonEmissiveLayers.entrySet()) {
                    int layer = Integer.parseInt((String)entry.getKey());
                    ForgeFaceData faceData = ForgeFaceData.read((JsonElement)jsonObject, (ForgeFaceData)ForgeFaceData.DEFAULT);
                    emissiveLayers.put(layer, (Object)faceData);
                }
            }
            return new OilCoatedItemModel(null, null, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, (Int2ObjectMap<ResourceLocation>)renderTypeNames);
        }
    }
}

