/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.IActionTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IRangedTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IThrowingTraitCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ToolAction;

public class WeaponTrait {
    public static final ChatFormatting[] DESCRIPTION_FORMAT = new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC};
    public static final ChatFormatting[] INVALID_FORMAT = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC};
    protected String type;
    protected String modId;
    protected int level = 0;
    protected float magnitude = 0.0f;
    protected TraitQuality quality;
    protected boolean isMelee = false;
    protected boolean isRanged = false;
    protected boolean isThrowing = false;
    @Deprecated(since="3.1.1", forRemoval=true)
    protected boolean isAction = false;
    protected MutableComponent types;

    public WeaponTrait(String typeIn, String modIdIn, TraitQuality qualityIn) {
        this.type = typeIn;
        this.modId = modIdIn;
        this.quality = qualityIn;
    }

    public String toString() {
        return String.format("WeaponTrait{Type: %s:%s - Level: %d - Magnitude: %f - Quality: %s}", this.modId, this.type, this.level, Float.valueOf(this.magnitude), this.quality.toString());
    }

    public String getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public WeaponTrait setLevel(int value) {
        this.level = value;
        return this;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public WeaponTrait setMagnitude(float value) {
        this.magnitude = value;
        return this;
    }

    public WeaponTrait setMelee() {
        this.isMelee = true;
        return this;
    }

    public WeaponTrait setRanged() {
        this.isRanged = true;
        return this;
    }

    public WeaponTrait setThrowing() {
        this.isThrowing = true;
        return this;
    }

    @Deprecated(since="3.1.1", forRemoval=true)
    public WeaponTrait setActionTrait() {
        this.isAction = true;
        return this;
    }

    public WeaponTrait setUniversal() {
        this.isMelee = true;
        this.isRanged = true;
        this.isThrowing = true;
        return this;
    }

    @Deprecated(since="3.1.1", forRemoval=true)
    public WeaponTrait setUniversal(boolean isActionIn) {
        this.isMelee = true;
        this.isRanged = true;
        this.isThrowing = true;
        this.isAction = isActionIn;
        return this;
    }

    public Optional<IMeleeTraitCallback> getMeleeCallback() {
        return Optional.empty();
    }

    public Optional<IRangedTraitCallback> getRangedCallback() {
        return Optional.empty();
    }

    public Optional<IThrowingTraitCallback> getThrowingCallback() {
        return Optional.empty();
    }

    public Optional<IActionTraitCallback> getActionCallback() {
        return Optional.empty();
    }

    public final boolean isMeleeTrait() {
        return this.isMelee || this.getMeleeCallback().isPresent();
    }

    public final boolean isRangedTrait() {
        return this.isRanged || this.getRangedCallback().isPresent();
    }

    public final boolean isThrowingTrait() {
        return this.isThrowing || this.getThrowingCallback().isPresent();
    }

    public final boolean isActionTrait() {
        return this.getActionCallback().isPresent();
    }

    public boolean isEnchantmentCompatible(Enchantment enchantIn) {
        return false;
    }

    public boolean isEnchantmentIncompatible(Enchantment enchantIn) {
        return false;
    }

    public boolean canPerformToolAction(ItemStack stack, ToolAction action) {
        return false;
    }

    public final void addTooltip(ItemStack stack, List<Component> tooltip, boolean isShiftPressed, InvalidReason invalidReason) {
        if (invalidReason == InvalidReason.NONE) {
            this.addTooltipTitle(stack, tooltip, this.quality.getFormatting());
        } else {
            this.addTooltipTitle(stack, tooltip, ChatFormatting.DARK_RED, ChatFormatting.BOLD, ChatFormatting.STRIKETHROUGH);
        }
        if (isShiftPressed) {
            if (this.types == null) {
                this.initTooltipTypes();
            } else {
                tooltip.add((Component)this.types);
            }
            if (I18n.m_118936_((String)String.format("tooltip.%s.trait.%s.desc", this.modId, this.type))) {
                if (invalidReason == InvalidReason.NONE) {
                    this.addTooltipDescription(stack, tooltip);
                } else {
                    tooltip.add((Component)WeaponTrait.tooltipIndent().m_7220_((Component)Component.m_237115_((String)String.format(invalidReason.getLanguageKey(), new Object[0])).m_130944_(INVALID_FORMAT)));
                }
            }
        }
    }

    public final void addTooltip(ItemStack stack, List<Component> tooltip, boolean isShiftPressed) {
        this.addTooltip(stack, tooltip, isShiftPressed, InvalidReason.NONE);
    }

    protected final void initTooltipTypes() {
        ArrayList<MutableComponent> traitTypesList = new ArrayList<MutableComponent>();
        MutableComponent comma = Component.m_237113_((String)", ");
        if (this.isActionTrait()) {
            traitTypesList.add(Component.m_237115_((String)String.format("tooltip.%s.trait.type.action", "spartanweaponry")));
        }
        if (this.isMeleeTrait()) {
            traitTypesList.add(Component.m_237115_((String)String.format("tooltip.%s.trait.type.melee", "spartanweaponry")));
        }
        if (this.isRangedTrait()) {
            traitTypesList.add(Component.m_237115_((String)String.format("tooltip.%s.trait.type.ranged", "spartanweaponry")));
        }
        if (this.isThrowingTrait()) {
            traitTypesList.add(Component.m_237115_((String)String.format("tooltip.%s.trait.type.throwing", "spartanweaponry")));
        }
        this.types = Component.m_237113_((String)"  [").m_7220_((Component)ComponentUtils.m_178436_(traitTypesList, (Component)comma, Function.identity())).m_7220_((Component)Component.m_237113_((String)"]")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY});
    }

    protected void addTooltipTitle(ItemStack stack, List<Component> tooltip, ChatFormatting ... formatting) {
        MutableComponent titleText = Component.m_237113_((String)"- ").m_130944_(formatting);
        if (this.level == 0) {
            tooltip.add((Component)titleText.m_7220_((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.%s", this.modId, this.type))));
        } else {
            tooltip.add((Component)titleText.m_7220_((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.%s", this.modId, this.type), (Object[])new Object[]{Component.m_237115_((String)("enchantment.level." + Integer.toString(this.level)))})));
        }
    }

    protected void addTooltipDescription(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)WeaponTrait.tooltipIndent().m_7220_((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.%s.desc", this.modId, this.type)).m_130944_(DESCRIPTION_FORMAT)));
    }

    protected static MutableComponent tooltipIndent() {
        return Component.m_237113_((String)"  ");
    }

    public static enum TraitQuality {
        POSITIVE(ChatFormatting.GREEN),
        NEUTRAL(ChatFormatting.YELLOW),
        NEGATIVE(ChatFormatting.RED);

        private ChatFormatting formatting;

        private TraitQuality(ChatFormatting formattingIn) {
            this.formatting = formattingIn;
        }

        public ChatFormatting getFormatting() {
            return this.formatting;
        }
    }

    public static enum InvalidReason {
        NONE("none"),
        MULTIPLE_ACTION_TRAITS("multiple_action_traits"),
        MATERIAL_ACTION_TRAIT("material_action_trait"),
        WEAPON_NOT_MELEE("weapon_not_melee"),
        WEAPON_NOT_RANGED("weapon_not_ranged"),
        WEAPON_NOT_THROWING("weapon_not_throwing"),
        WEAPON_NOT_SUPPORTED("weapon_not_supported");

        private String langKey;

        private InvalidReason(String langKeySuffixIn) {
            this.langKey = String.format("tooltip.%s.trait.invalid.%s", "spartanweaponry", langKeySuffixIn);
        }

        public String getLanguageKey() {
            return this.langKey;
        }
    }
}

