/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.IActionTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ThrowableMeleeWeaponTrait
extends WeaponTrait
implements IActionTraitCallback {
    public ThrowableMeleeWeaponTrait(String typeIn, String modIdIn, WeaponTrait.TraitQuality qualityIn) {
        super(typeIn, modIdIn, qualityIn);
        this.isMelee = true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack usingStackIn, Level levelIn, Player playerIn, InteractionHand handIn) {
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)usingStackIn);
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @Override
    public Optional<IActionTraitCallback> getActionCallback() {
        return Optional.of(this);
    }

    @Override
    public void releaseUsing(ItemStack stackIn, Level levelIn, LivingEntity entityLivingIn, int timeLeftIn, float attackDamage) {
        if (entityLivingIn instanceof Player) {
            Player player = (Player)entityLivingIn;
            int charge = this.getUseDuration(stackIn) - timeLeftIn;
            if (charge >= 5) {
                charge = 5;
            }
            if (!levelIn.f_46443_ && charge > 2) {
                int k;
                ThrowingWeaponEntity thrown = new ThrowingWeaponEntity((EntityType<? extends ThrowingWeaponEntity>)((EntityType)ModEntities.THROWING_WEAPON.get()), (LivingEntity)player, levelIn);
                thrown.setWeapon(stackIn);
                thrown.m_37251_((Entity)player, player.f_19860_, player.f_19859_, 0.0f, 1.5f * ((float)charge / 10.0f + 0.5f), 0.5f);
                thrown.m_36781_(attackDamage + 1.0f);
                int j = stackIn.getEnchantmentLevel(Enchantments.f_44977_);
                if (j > 0) {
                    thrown.m_36781_(thrown.m_36789_() + (double)j * 0.5 + 0.5);
                }
                if ((k = stackIn.getEnchantmentLevel(Enchantments.f_44980_)) > 0) {
                    thrown.m_36735_(k);
                }
                if (stackIn.getEnchantmentLevel(Enchantments.f_44981_) > 0) {
                    thrown.m_20254_(100);
                }
                if (player.m_150110_().f_35937_) {
                    thrown.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stackIn.m_41774_(1);
                    if (stackIn.m_41613_() <= 0) {
                        player.m_150109_().m_36057_(stackIn);
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    levelIn.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.THROWN_WEAPON_THROW.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (levelIn.f_46441_.m_188501_() * 0.4f + 0.8f));
                    levelIn.m_7967_((Entity)thrown);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stackIn.m_41720_()));
        }
    }
}

