/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.api.tags.ModWeaponTraitTags;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;

public class WeaponMaterial
implements Tier,
IReloadable {
    public static final WeaponMaterial WOOD = new WeaponMaterial("wood", "spartanweaponry", (Tier)Tiers.WOOD, (TagKey<Item>)ItemTags.f_13168_, ModWeaponTraitTags.WOOD);
    public static final WeaponMaterial STONE = new WeaponMaterial("stone", "spartanweaponry", (Tier)Tiers.STONE, ModItemTags.COBBLESTONE, ModWeaponTraitTags.STONE);
    public static final WeaponMaterial LEATHER = new WeaponMaterial("leather", "spartanweaponry", 128, 2.0f, 0.0f, 5, ModItemTags.LEATHER, ModWeaponTraitTags.LEATHER);
    public static final WeaponMaterial COPPER = new WeaponMaterial("copper", "spartanweaponry", 200, 5.0f, 1.5f, 8, ModItemTags.COPPER_INGOT, ModWeaponTraitTags.COPPER);
    public static final WeaponMaterial IRON = new WeaponMaterial("iron", "spartanweaponry", (Tier)Tiers.IRON, ModItemTags.IRON_INGOT, ModWeaponTraitTags.IRON);
    public static final WeaponMaterial GOLD = new WeaponMaterial("gold", "spartanweaponry", (Tier)Tiers.GOLD, ModItemTags.GOLD_INGOT, ModWeaponTraitTags.GOLD);
    public static final WeaponMaterial DIAMOND = new WeaponMaterial("diamond", "spartanweaponry", (Tier)Tiers.DIAMOND, ModItemTags.DIAMOND, ModWeaponTraitTags.DIAMOND);
    public static final WeaponMaterial NETHERITE = new WeaponMaterial("netherite", "spartanweaponry", (Tier)Tiers.NETHERITE, ModItemTags.NETHERITE_INGOT, ModWeaponTraitTags.NETHERITE);
    public static final WeaponMaterial TIN = new WeaponMaterial("tin", "spartanweaponry", 12500696, 0xD2D2FF, 180, 5.25f, 1.75f, 6, ModItemTags.TIN_INGOT, ModWeaponTraitTags.TIN);
    public static final WeaponMaterial BRONZE = new WeaponMaterial("bronze", "spartanweaponry", 11758858, 13407798, 320, 5.75f, 2.0f, 12, ModItemTags.BRONZE_INGOT, ModWeaponTraitTags.BRONZE);
    public static final WeaponMaterial STEEL = new WeaponMaterial("steel", "spartanweaponry", 0x858585, 0xBEBEBE, 480, 6.5f, 2.5f, 14, ModItemTags.STEEL_INGOT, ModWeaponTraitTags.STEEL);
    public static final WeaponMaterial SILVER = new WeaponMaterial("silver", "spartanweaponry", 13487600, 0xFFFFFF, 48, 5.0f, 1.5f, 16, ModItemTags.SILVER_INGOT, ModWeaponTraitTags.SILVER);
    public static final WeaponMaterial ELECTRUM = new WeaponMaterial("electrum", "spartanweaponry", 14007119, 0xFFFF95, 180, 3.5f, 2.0f, 8, ModItemTags.ELECTRUM_INGOT, ModWeaponTraitTags.ELECTRUM);
    public static final WeaponMaterial LEAD = new WeaponMaterial("lead", "spartanweaponry", 5726589, 9150162, 240, 4.5f, 2.0f, 5, ModItemTags.LEAD_INGOT, ModWeaponTraitTags.LEAD);
    public static final WeaponMaterial NICKEL = new WeaponMaterial("nickel", "spartanweaponry", 14405525, 16250827, 200, 4.5f, 2.0f, 6, ModItemTags.NICKEL_INGOT, ModWeaponTraitTags.NICKEL);
    public static final WeaponMaterial INVAR = new WeaponMaterial("invar", "spartanweaponry", 11450027, 14607328, 440, 6.0f, 2.25f, 12, ModItemTags.INVAR_INGOT, ModWeaponTraitTags.INVAR);
    public static final WeaponMaterial CONSTANTAN = new WeaponMaterial("constantan", "spartanweaponry", 11828308, 16242348, 300, 5.5f, 2.25f, 7, ModItemTags.CONSTANTAN_INGOT, ModWeaponTraitTags.CONSTANTAN);
    public static final WeaponMaterial PLATINUM = new WeaponMaterial("platinum", "spartanweaponry", 6937328, 11200511, 1024, 4.0f, 3.5f, 18, ModItemTags.PLATINUM_INGOT, ModWeaponTraitTags.PLATINUM);
    public static final WeaponMaterial ALUMINUM = new WeaponMaterial("aluminum", "spartanweaponry", 11451327, 0xF9FFFF, 400, 5.0f, 2.125f, 7, ModItemTags.ALUMINUM_INGOT, ModWeaponTraitTags.ALUMINUM);
    private int durability;
    private final float speed;
    private float baseDamage;
    private final int enchantability;
    private final LazyLoadedValue<Ingredient> repairMaterial;
    private final TagKey<Item> repairTag;
    private final String name;
    private final String modId;
    private int colourPrimary = 0x7F7F7F;
    private int colourSecondary = 0xFFFFFF;
    private boolean useCustomDisplayName = false;
    private Function<String, String> translationFunc = null;
    protected List<WeaponTrait> traits;
    protected List<WeaponTrait> meleeTraits;
    protected List<WeaponTrait> rangedTraits;
    protected List<WeaponTrait> throwingTraits;
    protected final TagKey<WeaponTrait> traitsTag;
    protected boolean isValidTag;
    protected Optional<List<Pair<WeaponTrait, WeaponTrait.InvalidReason>>> invalidTraits = Optional.empty();

    public WeaponMaterial(String nameIn, String modIdIn, int colourPrimaryIn, int colourSecondaryIn, int durabilityIn, float speedIn, float baseDamageIn, int enchantabilityIn, TagKey<Item> repairTagIn, TagKey<WeaponTrait> traitsTagIn) {
        this.name = nameIn;
        this.modId = modIdIn;
        this.colourPrimary = colourPrimaryIn;
        this.colourSecondary = colourSecondaryIn;
        this.durability = durabilityIn;
        this.speed = speedIn;
        this.baseDamage = baseDamageIn;
        this.enchantability = enchantabilityIn;
        this.repairTag = repairTagIn;
        this.repairMaterial = new LazyLoadedValue(() -> Ingredient.m_204132_((TagKey)repairTagIn));
        this.traitsTag = traitsTagIn;
        ReloadableHandler.addToReloadList(this);
    }

    public WeaponMaterial(String unlocName, String modIdIn, int maxUses, float efficiency, float baseDamage, int enchantability, TagKey<Item> tag, TagKey<WeaponTrait> traitsTagIn) {
        this(unlocName, modIdIn, 0x7F7F7F, 0xFFFFFF, maxUses, efficiency, baseDamage, enchantability, tag, traitsTagIn);
    }

    public WeaponMaterial(String nameIn, String modIdIn, Tier itemTierIn, TagKey<Item> tagIn, TagKey<WeaponTrait> traitsTagIn) {
        this(nameIn, modIdIn, 0x7F7F7F, 0xFFFFFF, itemTierIn.m_6609_(), itemTierIn.m_6624_(), itemTierIn.m_6631_(), itemTierIn.m_6601_(), tagIn, traitsTagIn);
    }

    @Override
    public void reload() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(WeaponTraits.REGISTRY_KEY);
        ITagManager tagManager = registry.tags();
        ImmutableList.Builder builder = ImmutableList.builder();
        this.isValidTag = tagManager.isKnownTagName(this.traitsTag);
        if (!this.isValidTag) {
            Log.error("Weapon Trait tag \"" + this.traitsTag.f_203868_() + "\" couldn't be found for weapon material \"" + this.name + "\"!");
            return;
        }
        ITag tag = tagManager.getTag(this.traitsTag);
        this.invalidTraits = Optional.empty();
        ArrayList invalidTraitList = new ArrayList();
        ArrayList invalidTraitValues = new ArrayList();
        builder.addAll((Iterable)tag.stream().filter(arg_0 -> WeaponMaterial.lambda$reload$1(invalidTraitList, invalidTraitValues, (IForgeRegistry)registry, arg_0)).collect(Collectors.toUnmodifiableList()));
        if (!invalidTraitValues.isEmpty()) {
            Log.warn("Found non-material Weapon Traits for weapon material \"" + this.name + "\" which have not been added: " + String.join((CharSequence)", ", invalidTraitValues));
            this.invalidTraits = Optional.of(invalidTraitList);
        }
        this.traits = builder.build();
        this.meleeTraits = this.traits.stream().filter(WeaponType.MELEE.getTraitFilter()).collect(Collectors.toUnmodifiableList());
        this.rangedTraits = this.traits.stream().filter(WeaponType.RANGED.getTraitFilter()).collect(Collectors.toUnmodifiableList());
        this.throwingTraits = this.traits.stream().filter(WeaponType.THROWING.getTraitFilter()).collect(Collectors.toUnmodifiableList());
    }

    public WeaponMaterial setUseCustomDisplayName() {
        this.useCustomDisplayName = true;
        return this;
    }

    public WeaponMaterial setUseCustomDisplayName(Function<String, String> translationFunc) {
        this.translationFunc = translationFunc;
        return this.setUseCustomDisplayName();
    }

    public boolean useCustomDisplayName() {
        return this.useCustomDisplayName;
    }

    public Component translateName() {
        if (this.translationFunc == null) {
            return Component.m_237115_((String)("material." + this.getModId() + "." + this.getMaterialName()));
        }
        return Component.m_237113_((String)this.translationFunc.apply(this.name));
    }

    public String getMaterialName() {
        return this.name;
    }

    public int getPrimaryColour() {
        return this.colourPrimary;
    }

    public int getSecondaryColour() {
        return this.colourSecondary;
    }

    public String getModId() {
        return this.modId;
    }

    public int m_6609_() {
        return this.durability;
    }

    public void setDurability(int maxUses) {
        this.durability = maxUses;
    }

    public float m_6624_() {
        return this.speed;
    }

    public float m_6631_() {
        return this.baseDamage;
    }

    public void setAttackDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public int m_6604_() {
        return 0;
    }

    public int m_6601_() {
        return this.enchantability;
    }

    public Ingredient m_6282_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    public TagKey<Item> getRepairTag() {
        return this.repairTag;
    }

    public String getRepairTagName() {
        return this.repairTag.f_203868_().toString();
    }

    public TagKey<WeaponTrait> getTraitsTag() {
        return this.traitsTag;
    }

    @Deprecated(since="3.1.1", forRemoval=true)
    public boolean hasAnyBonusTraits() {
        return this.traits != null && (!this.traits.isEmpty() || this.invalidTraits.isPresent());
    }

    public boolean hasAnyBonusTraits(WeaponType type) {
        List<WeaponTrait> weaponTraits;
        switch (type) {
            case MELEE: {
                weaponTraits = this.meleeTraits;
                break;
            }
            case RANGED: {
                weaponTraits = this.rangedTraits;
                break;
            }
            case THROWING: {
                weaponTraits = this.throwingTraits;
                break;
            }
            default: {
                return false;
            }
        }
        return weaponTraits != null && (!weaponTraits.isEmpty() || this.invalidTraits.isPresent());
    }

    @Deprecated(since="3.1.1", forRemoval=true)
    public List<WeaponTrait> getBonusTraits() {
        return this.traits;
    }

    public List<WeaponTrait> getBonusTraits(WeaponType type) {
        switch (type) {
            case MELEE: {
                return this.meleeTraits;
            }
            case RANGED: {
                return this.rangedTraits;
            }
            case THROWING: {
                return this.throwingTraits;
            }
        }
        return List.of();
    }

    public void addTagErrorTooltip(ItemStack stack, List<Component> tooltip) {
        if (!this.isValidTag) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.invalid.material_tag", "spartanweaponry"), (Object[])new Object[]{Component.m_237115_((String)String.format("tooltip.%s.material.%s", "spartanweaponry", this.name)), this.traitsTag.f_203868_()}).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public void addTraitsToTooltip(ItemStack stack, WeaponType type, List<Component> tooltip, boolean isShiftPressed) {
        if (this.hasAnyBonusTraits(type)) {
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.material_bonus", "spartanweaponry")).m_130940_(ChatFormatting.AQUA));
            this.traits.forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed, WeaponTrait.InvalidReason.NONE));
        }
        if (this.invalidTraits.isPresent()) {
            this.invalidTraits.get().forEach(traitPair -> ((WeaponTrait)traitPair.getLeft()).addTooltip(stack, tooltip, isShiftPressed, (WeaponTrait.InvalidReason)((Object)((Object)traitPair.getRight()))));
        }
    }

    @Deprecated(since="3.1.1", forRemoval=true)
    public void addTraitsToTooltip(ItemStack stack, List<Component> tooltip, boolean isShiftPressed) {
        if (this.hasAnyBonusTraits()) {
            this.traits.forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed, WeaponTrait.InvalidReason.NONE));
        }
        if (this.invalidTraits.isPresent()) {
            this.invalidTraits.get().forEach(traitPair -> ((WeaponTrait)traitPair.getLeft()).addTooltip(stack, tooltip, isShiftPressed, (WeaponTrait.InvalidReason)((Object)((Object)traitPair.getRight()))));
        }
    }

    public static int colorRGB(byte r, byte g, byte b) {
        int color = (r << 16) + (g << 8) + b;
        return color;
    }

    private static /* synthetic */ boolean lambda$reload$1(List invalidTraitList, List invalidTraitValues, IForgeRegistry registry, WeaponTrait trait) {
        boolean isActionTrait = trait.isActionTrait();
        if (isActionTrait) {
            invalidTraitList.add(Pair.of((Object)trait, (Object)((Object)WeaponTrait.InvalidReason.MATERIAL_ACTION_TRAIT)));
            invalidTraitValues.add(registry.getKey((Object)trait).toString());
        }
        return !isActionTrait;
    }
}

