/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.model;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tlauncher.model.MinecraftProfileTextureDTO;
import org.tlauncher.model.PlayerName;
import org.tlauncher.renderer.image.ImageWrap;

public class PreparedTextureData {
    private PlayerName name;
    private volatile Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profileTextureDTO = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>();
    private Map<MinecraftProfileTexture.Type, ImageWrap> images = Collections.synchronizedMap(new HashMap());
    private List<ImageWrap> capeFrames = new ArrayList<ImageWrap>();
    private ImageWrap skin;
    private int preparedIndexFrame;
    private long maxTimeLoad;
    private long initTime = System.currentTimeMillis();
    private boolean hasElytra;
    private boolean hasAnimatedElytra;

    public boolean hasFrame() {
        return this.preparedIndexFrame < this.capeFrames.size();
    }

    public int getPreparedIndexFrameAndIncrease() {
        return this.preparedIndexFrame++;
    }

    public void setMaxTimeLoad(long maxTimeLoad) {
        if (this.maxTimeLoad < maxTimeLoad) {
            this.maxTimeLoad = maxTimeLoad;
        }
    }

    public PlayerName getName() {
        return this.name;
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> getProfileTextureDTO() {
        return this.profileTextureDTO;
    }

    public Map<MinecraftProfileTexture.Type, ImageWrap> getImages() {
        return this.images;
    }

    public List<ImageWrap> getCapeFrames() {
        return this.capeFrames;
    }

    public ImageWrap getSkin() {
        return this.skin;
    }

    public int getPreparedIndexFrame() {
        return this.preparedIndexFrame;
    }

    public long getMaxTimeLoad() {
        return this.maxTimeLoad;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public boolean isHasElytra() {
        return this.hasElytra;
    }

    public boolean isHasAnimatedElytra() {
        return this.hasAnimatedElytra;
    }

    public void setName(PlayerName name) {
        this.name = name;
    }

    public void setProfileTextureDTO(Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profileTextureDTO) {
        this.profileTextureDTO = profileTextureDTO;
    }

    public void setImages(Map<MinecraftProfileTexture.Type, ImageWrap> images) {
        this.images = images;
    }

    public void setCapeFrames(List<ImageWrap> capeFrames) {
        this.capeFrames = capeFrames;
    }

    public void setSkin(ImageWrap skin) {
        this.skin = skin;
    }

    public void setPreparedIndexFrame(int preparedIndexFrame) {
        this.preparedIndexFrame = preparedIndexFrame;
    }

    public void setInitTime(long initTime) {
        this.initTime = initTime;
    }

    public void setHasElytra(boolean hasElytra) {
        this.hasElytra = hasElytra;
    }

    public void setHasAnimatedElytra(boolean hasAnimatedElytra) {
        this.hasAnimatedElytra = hasAnimatedElytra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreparedTextureData)) {
            return false;
        }
        PreparedTextureData other = (PreparedTextureData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPreparedIndexFrame() != other.getPreparedIndexFrame()) {
            return false;
        }
        if (this.getMaxTimeLoad() != other.getMaxTimeLoad()) {
            return false;
        }
        if (this.getInitTime() != other.getInitTime()) {
            return false;
        }
        if (this.isHasElytra() != other.isHasElytra()) {
            return false;
        }
        if (this.isHasAnimatedElytra() != other.isHasAnimatedElytra()) {
            return false;
        }
        PlayerName this$name = this.getName();
        PlayerName other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> this$profileTextureDTO = this.getProfileTextureDTO();
        Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> other$profileTextureDTO = other.getProfileTextureDTO();
        if (this$profileTextureDTO == null ? other$profileTextureDTO != null : !((Object)this$profileTextureDTO).equals(other$profileTextureDTO)) {
            return false;
        }
        Map<MinecraftProfileTexture.Type, ImageWrap> this$images = this.getImages();
        Map<MinecraftProfileTexture.Type, ImageWrap> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        List<ImageWrap> this$capeFrames = this.getCapeFrames();
        List<ImageWrap> other$capeFrames = other.getCapeFrames();
        if (this$capeFrames == null ? other$capeFrames != null : !((Object)this$capeFrames).equals(other$capeFrames)) {
            return false;
        }
        ImageWrap this$skin = this.getSkin();
        ImageWrap other$skin = other.getSkin();
        return !(this$skin == null ? other$skin != null : !this$skin.equals(other$skin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreparedTextureData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPreparedIndexFrame();
        long $maxTimeLoad = this.getMaxTimeLoad();
        result = result * 59 + (int)($maxTimeLoad >>> 32 ^ $maxTimeLoad);
        long $initTime = this.getInitTime();
        result = result * 59 + (int)($initTime >>> 32 ^ $initTime);
        result = result * 59 + (this.isHasElytra() ? 79 : 97);
        result = result * 59 + (this.isHasAnimatedElytra() ? 79 : 97);
        PlayerName $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> $profileTextureDTO = this.getProfileTextureDTO();
        result = result * 59 + ($profileTextureDTO == null ? 43 : ((Object)$profileTextureDTO).hashCode());
        Map<MinecraftProfileTexture.Type, ImageWrap> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        List<ImageWrap> $capeFrames = this.getCapeFrames();
        result = result * 59 + ($capeFrames == null ? 43 : ((Object)$capeFrames).hashCode());
        ImageWrap $skin = this.getSkin();
        result = result * 59 + ($skin == null ? 43 : $skin.hashCode());
        return result;
    }

    public String toString() {
        return "PreparedTextureData(name=" + this.getName() + ", profileTextureDTO=" + this.getProfileTextureDTO() + ", images=" + this.getImages() + ", capeFrames=" + this.getCapeFrames() + ", skin=" + this.getSkin() + ", preparedIndexFrame=" + this.getPreparedIndexFrame() + ", maxTimeLoad=" + this.getMaxTimeLoad() + ", initTime=" + this.getInitTime() + ", hasElytra=" + this.isHasElytra() + ", hasAnimatedElytra=" + this.isHasAnimatedElytra() + ")";
    }
}

