/*
 * Decompiled with CFR 0.152.
 */
package net.palegarden.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.palegarden.entity.CreakingEntity;
import net.palegarden.entity.CreakingHeartEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PalegardenModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"palegarden");
    public static final RegistryObject<EntityType<CreakingEntity>> CREAKING = PalegardenModEntities.register("creaking", EntityType.Builder.m_20704_(CreakingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(3).setCustomClientFactory(CreakingEntity::new).m_20699_(0.9f, 2.1f));
    public static final RegistryObject<EntityType<CreakingHeartEntity>> CREAKING_HEART = PalegardenModEntities.register("creaking_heart", EntityType.Builder.m_20704_(CreakingHeartEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CreakingHeartEntity::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CreakingEntity.init();
            CreakingHeartEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CREAKING.get(), CreakingEntity.createAttributes().m_22265_());
        event.put((EntityType)CREAKING_HEART.get(), CreakingHeartEntity.createAttributes().m_22265_());
    }
}

