/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.inventory.CraftResultSlot;
import com.jaquadro.minecraft.storagedrawers.inventory.RestrictedSlot;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerFramingTable
extends AbstractContainerMenu {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private static final int InputX = 23;
    private static final int InputY = 35;
    private static final int MaterialSideX = 50;
    private static final int MaterialSideY = 17;
    private static final int MaterialTrimX = 102;
    private static final int MaterialTrimY = 17;
    private static final int MaterialFrontX = 50;
    private static final int MaterialFrontY = 53;
    private static final int OutputX = 133;
    private static final int OutputY = 35;
    private final BlockEntityFramingTable blockEntity;
    private final Container tableInventory;
    private final Container craftResult;
    private final ContainerLevelAccess access;
    private final Player player;
    private Slot inputSlot;
    private Slot materialSideSlot;
    private Slot materialTrimSlot;
    private Slot materialFrontSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerFramingTable(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(type, windowId, playerInv, ContainerFramingTable.getBlockEntity(playerInv, data.m_130135_()));
    }

    public ContainerFramingTable(int windowId, Inventory playerInventory, FriendlyByteBuf packet) {
        this((MenuType)ModContainers.FRAMING_TABLE.get(), windowId, playerInventory, packet);
    }

    protected static BlockEntityFramingTable getBlockEntity(Inventory playerInv, BlockPos pos) {
        Level level = playerInv.f_35978_.m_20193_();
        BlockEntityFramingTable blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos, BlockEntityFramingTable.class);
        if (blockEntity != null) {
            return blockEntity;
        }
        StorageDrawers.log.error("Expected a framing table tile entity at " + pos);
        return null;
    }

    public ContainerFramingTable(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, BlockEntityFramingTable blockEntity) {
        super(type, windowId);
        int i;
        this.blockEntity = blockEntity;
        this.tableInventory = blockEntity.inventory();
        this.craftResult = blockEntity.inventory();
        this.access = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.player = playerInventory.f_35978_;
        this.inputSlot = this.m_38897_(new RestrictedSlot(this.tableInventory, 0, 23, 35));
        this.materialSideSlot = this.m_38897_(new RestrictedSlot(this.tableInventory, 1, 50, 17));
        this.materialTrimSlot = this.m_38897_(new RestrictedSlot(this.tableInventory, 2, 102, 17));
        this.materialFrontSlot = this.m_38897_(new RestrictedSlot(this.tableInventory, 3, 50, 53));
        this.outputSlot = this.m_38897_(new CraftResultSlot(playerInventory.f_35978_, this.tableInventory, this.craftResult, new int[]{0, 1, 2, 3}, 4, 133, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142)));
        }
        this.m_6199_(this.tableInventory);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).f_40219_;
        int hotbarStart = this.hotbarSlots.get((int)0).f_40219_;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).f_40219_ + 1;
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (slotIndex == 4) {
                if (!this.m_38903_(slotStack, inventoryStart, hotbarEnd, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemStack);
            } else if (slotIndex == 0 || BlockEntityFramingTable.isMaterialSlot(slotIndex) ? !this.m_38903_(slotStack, inventoryStart, hotbarEnd, true) : slotIndex >= inventoryStart && slotIndex < hotbarEnd && (this.blockEntity.isItemValidTarget(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (BlockEntityFramingTable.isItemValidMaterial(slotStack) ? !this.m_38903_(slotStack, 1, 4, false) : (slotIndex < hotbarStart ? !this.m_38903_(slotStack, hotbarStart, hotbarEnd, false) : !this.m_38903_(slotStack, inventoryStart, hotbarStart, false))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.tableInventory.m_6542_(player);
    }
}

