/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10096;
import net.minecraft.class_10101;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4724;
import net.minecraft.class_790;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.util.DynamicMap;

public class DynamicModelProvider {
    private final LoadingCache<class_2960, Optional<class_9824.class_10095>> loadedStateDefinitions = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build((CacheLoader)new CacheLoader<class_2960, Optional<class_9824.class_10095>>(){

        public Optional<class_9824.class_10095> load(class_2960 key) {
            return DynamicModelProvider.this.loadBlockStateDefinition(key);
        }
    });
    private final LoadingCache<class_2960, Optional<class_1100>> loadedBlockModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build((CacheLoader)new CacheLoader<class_2960, Optional<class_1100>>(){

        public Optional<class_1100> load(class_2960 key) {
            return DynamicModelProvider.this.loadBlockModel(key);
        }
    });
    private final LoadingCache<class_1091, Optional<class_1100>> loadedUnbakedModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build((CacheLoader)new CacheLoader<class_1091, Optional<class_1100>>(){

        public Optional<class_1100> load(class_1091 key) {
            return DynamicModelProvider.this.loadModel(key);
        }
    });
    private final LoadingCache<class_1091, Optional<class_1087>> loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build((CacheLoader)new CacheLoader<class_1091, Optional<class_1087>>(){

        public Optional<class_1087> load(class_1091 key) {
            return DynamicModelProvider.this.loadBakedModel(key);
        }
    });
    private final Map<class_1091, class_1087> initialBakedRegistry;
    private final class_1087 missingModel;
    private final class_1100 unbakedMissingModel;
    private final Function<class_2960, class_2689<class_2248, class_2680>> stateMapper;
    private final class_3300 resourceManager;
    private final class_9824 blockStateModelLoader;
    private final class_1088.class_9826 textureGetter;
    private final DynamicMap<class_2960, class_1100> fakeUnbakedModelMap;
    private final DynamicResolver resolver;

    public DynamicModelProvider(Map<class_1091, class_1087> initialBakedRegistry, class_1087 missingModel, class_3300 resourceManager, Map<class_2960, class_4724.class_7774> atlasMap) {
        this.initialBakedRegistry = initialBakedRegistry;
        this.missingModel = missingModel;
        this.textureGetter = (mrl, material) -> {
            class_4724.class_7774 atlas = (class_4724.class_7774)atlasMap.get(material.method_24144());
            class_1058 sprite = atlas.method_45869(material.method_24147());
            if (sprite != null) {
                return sprite;
            }
            ModernFix.LOGGER.warn("Unable to find sprite '{}' referenced by model '{}'", (Object)material.method_24147(), (Object)mrl);
            return atlas.method_45868();
        };
        this.stateMapper = class_9824.method_62626();
        this.resourceManager = resourceManager;
        this.unbakedMissingModel = class_10096.method_62629();
        this.blockStateModelLoader = new class_9824(this.unbakedMissingModel);
        this.fakeUnbakedModelMap = new DynamicMap<class_2960, class_1100>(class_2960.class, key -> ((Optional)this.loadedBlockModels.getUnchecked(key)).orElse(null));
        this.resolver = new DynamicResolver();
    }

    private Optional<class_9824.class_10095> loadBlockStateDefinition(class_2960 location) {
        class_2689<class_2248, class_2680> stateDefinition = this.stateMapper.apply(location);
        if (stateDefinition == null) {
            return Optional.empty();
        }
        List resources = this.resourceManager.method_14489(class_2960.method_60655((String)location.method_12836(), (String)("blockstates/" + location.method_12832() + ".json")));
        ArrayList<class_9824.class_10094> loadedDefinitions = new ArrayList<class_9824.class_10094>(resources.size());
        for (class_3298 resource : resources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonObject jsonObject = class_3518.method_15255((Reader)reader);
                    class_790 blockModelDefinition = class_790.method_45787((JsonElement)jsonObject);
                    loadedDefinitions.add(new class_9824.class_10094(resource.method_14480(), blockModelDefinition));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                ModernFix.LOGGER.error("Failed to load blockstate definition {} from pack '{}'", (Object)location, (Object)resource.method_14480(), (Object)e);
            }
        }
        return Optional.of(this.blockStateModelLoader.method_62627(location, stateDefinition, loadedDefinitions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_1087 bakeModel(class_1100 model, class_1091 location) {
        DynamicModelProvider dynamicModelProvider = this;
        synchronized (dynamicModelProvider) {
            this.resolver.clearResolver();
            model.method_62326((class_1100.class_10103)this.resolver);
            class_1088 modelBakery = new class_1088(Map.of(location, model), this.fakeUnbakedModelMap, this.unbakedMissingModel);
            modelBakery.method_45876(this.textureGetter);
            return (class_1087)modelBakery.method_4734().get(location);
        }
    }

    private Optional<class_1087> loadBakedModel(class_1091 location) {
        Optional unbakedModel = (Optional)this.loadedUnbakedModels.getUnchecked((Object)location);
        return unbakedModel.map(model -> this.bakeModel((class_1100)model, location));
    }

    private Optional<class_1100> loadBlockModel(class_2960 location) {
        if (location.equals((Object)class_10101.field_53677)) {
            return Optional.of(class_10101.field_53679);
        }
        if (location.equals((Object)class_10101.field_53678)) {
            return Optional.of(class_10101.field_53680);
        }
        Optional resource = this.resourceManager.method_14486(class_2960.method_60655((String)location.method_12836(), (String)("models/" + location.method_12832() + ".json")));
        if (resource.isPresent()) {
            Optional<class_793> optional;
            block11: {
                BufferedReader reader = ((class_3298)resource.get()).method_43039();
                try {
                    class_793 blockModel = class_793.method_3437((Reader)reader);
                    blockModel.field_4252 = location.toString();
                    optional = Optional.of(blockModel);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        ModernFix.LOGGER.error("Failed to load block model {} from '{}'", (Object)location, (Object)((class_3298)resource.get()).method_14480(), (Object)e);
                        return Optional.empty();
                    }
                }
                ((Reader)reader).close();
            }
            return optional;
        }
        ModernFix.LOGGER.warn("Model '{}' does not exist in any resource packs", (Object)location);
        return Optional.empty();
    }

    private Optional<class_1100> loadModel(class_1091 location) {
        if (location.comp_2876().equals("inventory")) {
            return (Optional)this.loadedBlockModels.getUnchecked((Object)class_2960.method_60655((String)location.comp_2875().method_12836(), (String)("item/" + location.comp_2875().method_12832())));
        }
        if (location.comp_2876().equals("standalone") || location.comp_2876().equals("fabric_resource")) {
            return (Optional)this.loadedBlockModels.getUnchecked((Object)location.comp_2875());
        }
        Optional optLoadedModels = (Optional)this.loadedStateDefinitions.getUnchecked((Object)location.comp_2875());
        return optLoadedModels.map(loadedModels -> {
            class_9824.class_9825 loadedModel = (class_9824.class_9825)loadedModels.comp_3063().get(location);
            if (loadedModel != null) {
                return loadedModel.comp_2871();
            }
            return null;
        });
    }

    public class_1087 getModel(class_1091 location) {
        return ((Optional)this.loadedBakedModels.getUnchecked((Object)location)).orElse(this.missingModel);
    }

    private class DynamicResolver
    implements class_1100.class_10103 {
        private final Set<class_2960> stack = new ObjectOpenHashSet(4);
        private final Set<class_2960> resolvedModels = new ObjectOpenHashSet();

        private DynamicResolver() {
        }

        public class_1100 method_62642(class_2960 resourceLocation) {
            if (this.stack.contains(resourceLocation)) {
                ModernFix.LOGGER.warn("Detected model loading loop: {}->{}", (Object)this.stacktraceToString(), (Object)resourceLocation);
                return DynamicModelProvider.this.unbakedMissingModel;
            }
            class_1100 unbakedModel = ((Optional)DynamicModelProvider.this.loadedBlockModels.getUnchecked((Object)resourceLocation)).orElse(DynamicModelProvider.this.unbakedMissingModel);
            if (this.resolvedModels.add(resourceLocation)) {
                this.stack.add(resourceLocation);
                unbakedModel.method_62326((class_1100.class_10103)this);
                this.stack.remove(resourceLocation);
            }
            return unbakedModel;
        }

        private String stacktraceToString() {
            return this.stack.stream().map(class_2960::toString).collect(Collectors.joining("->"));
        }

        public void clearResolver() {
            this.stack.clear();
            this.resolvedModels.clear();
        }
    }
}

