/*
 * Decompiled with CFR 0.152.
 */
package qwebnm.mods.multiversepouch.util;

import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import qwebnm.mods.multiversepouch.MultiversePouch;

public class InventoryOperator {
    ItemStack itemstack;
    private static EntityPlayer player;
    String ext = ".dat";

    public File saveFolder() {
        return (File)FMLInjectionData.data()[6];
    }

    public void setPlayer(EntityPlayer player) {
        InventoryOperator.player = player;
    }

    public EntityPlayer getPlayer() {
        return player;
    }

    public NBTTagList getWorldIDPair(World worldIn) {
        File file = new File(worldIn.func_72860_G().func_75765_b(), "level.dat");
        try {
            FileInputStream filein = new FileInputStream(file);
            DataInputStream datain = new DataInputStream(filein);
            NBTTagCompound leveldat = CompressedStreamTools.func_74796_a((InputStream)datain);
            datain.close();
            filein.close();
            return leveldat.func_74775_l("FML").func_150295_c("ItemData", 10);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InventoryBasic loadInventoryFromFile(InventoryBasic inv, String foldername, String sub, World worldIn) {
        File folder;
        System.out.println("read");
        if (MultiversePouch.optionalDirectory) {
            System.out.println("OptionalDirectory:true");
            new File(MultiversePouch.directory).mkdirs();
            folder = new File(MultiversePouch.directory, foldername);
        } else {
            System.out.println("OptionalDirectory:false");
            folder = new File(this.saveFolder(), foldername);
        }
        if (!new File(folder, "data_" + sub + this.ext).exists()) {
            return null;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, (ItemStack)null);
        }
        boolean hasNext = true;
        File file = new File(folder, "data_" + sub + this.ext);
        try {
            FileInputStream filein = new FileInputStream(file);
            DataInputStream datain = new DataInputStream(filein);
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74794_a((DataInputStream)datain);
            datain.close();
            filein.close();
            NBTTagList pair = this.getWorldIDPair(worldIn);
            if (nbttagcompound.func_82582_d()) {
                hasNext = false;
            }
            int i = 0;
            while (hasNext) {
                NBTTagCompound cache = (NBTTagCompound)nbttagcompound.func_74781_a("data_" + i);
                int j = cache.func_74762_e("Slot");
                String id = cache.func_74779_i("id");
                boolean matched = false;
                int i_id = 0;
                for (int checked = 0; !matched && pair.func_74745_c() > checked; ++checked) {
                    NBTTagCompound cache_2 = pair.func_150305_b(checked);
                    if (!cache_2.func_74779_i("K").equals(id)) continue;
                    matched = true;
                    i_id = cache_2.func_74762_e("V");
                }
                if (!matched) {
                    if (nbttagcompound.func_74781_a("data_" + (i + 1)) == null) {
                        hasNext = false;
                    }
                } else {
                    cache.func_82580_o("id");
                    cache.func_74777_a("id", (short)i_id);
                    if (j >= 0 && j < inv.func_70302_i_()) {
                        inv.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)cache));
                    }
                    if (nbttagcompound.func_74781_a("data_" + (i + 1)) == null) {
                        hasNext = false;
                    }
                }
                ++i;
            }
            file.delete();
            return inv;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean writeInventoryToFile(InventoryBasic inv, String foldername, String sub, World worldIn) {
        File folder;
        System.out.println("write");
        if (MultiversePouch.optionalDirectory) {
            System.out.println("OptionalDirectory:true");
            new File(MultiversePouch.directory).mkdirs();
            folder = new File(MultiversePouch.directory, foldername);
        } else {
            System.out.println("OptionalDirectory:false");
            folder = new File(this.saveFolder(), foldername);
        }
        folder.mkdir();
        try {
            String invname = inv.func_145825_b();
            NBTTagCompound inventory = this.inventoryList(inv, worldIn);
            if (inventory.func_82582_d()) {
                return false;
            }
            File file = new File(folder, "data_" + sub + this.ext);
            FileOutputStream fileout = new FileOutputStream(file);
            DataOutputStream dataout = new DataOutputStream(fileout);
            CompressedStreamTools.func_74800_a((NBTTagCompound)inventory, (DataOutput)dataout);
            dataout.close();
            fileout.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public NBTTagCompound inventoryList(InventoryBasic data, World worldIn) {
        InventoryBasic inv = data;
        NBTTagCompound comp = new NBTTagCompound();
        int invsize = inv.func_70302_i_();
        int number = 0;
        NBTTagList pair = this.getWorldIDPair(worldIn);
        for (int i = 0; i < invsize; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack == null || itemstack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            itemstack.func_77955_b(item);
            item.func_74768_a("Slot", i);
            short id = item.func_74765_d("id");
            int checked = 0;
            boolean matched = false;
            String s_id = null;
            while (!matched) {
                NBTTagCompound cache_2 = pair.func_150305_b(checked);
                if (cache_2.func_74765_d("V") == id) {
                    matched = true;
                    s_id = cache_2.func_74779_i("K");
                }
                ++checked;
            }
            item.func_82580_o("id");
            item.func_74778_a("id", s_id);
            comp.func_74782_a("data_" + number, (NBTBase)item);
            ++number;
        }
        return comp;
    }

    public int isExistingItems(InventoryBasic inv) {
        int exists = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack == null || itemstack == null) continue;
            ++exists;
        }
        return exists;
    }
}

