/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftplus._common.packet;

import com.minecraftplus._common.packet.Packet;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    private String modChannel;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends Packet>> packets = new LinkedList();
    private boolean hasPostInit = false;

    public PacketHandler(String par1Channel) {
        this.modChannel = par1Channel;
    }

    public boolean registerPacket(Class<? extends Packet> parClass) {
        if (this.packets.size() > 256) {
            return false;
        }
        if (this.packets.contains(parClass)) {
            return false;
        }
        if (this.hasPostInit) {
            return false;
        }
        this.packets.add(parClass);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> msgClass = msg.getClass();
        if (!this.packets.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(msgClass);
        buffer.writeByte((int)discriminator);
        msg.encode(ctx, buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends Packet> packetClass = this.packets.get(discriminator);
        if (packetClass == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        Packet pkt = packetClass.newInstance();
        pkt.decode(ctx, payload.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                pkt.onClientSide(player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                pkt.onServerSide((EntityPlayer)player);
                break;
            }
        }
        out.add(pkt);
    }

    public void initialize() {
        this.channels = NetworkRegistry.INSTANCE.newChannel(this.modChannel, new ChannelHandler[]{this});
    }

    public void postInitialize() {
        if (this.hasPostInit) {
            return;
        }
        this.hasPostInit = true;
        Collections.sort(this.packets, new Comparator<Class<? extends Packet>>(){

            @Override
            public int compare(Class<? extends Packet> parClass1, Class<? extends Packet> parClass2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(parClass1.getCanonicalName(), parClass2.getCanonicalName());
                if (com == 0) {
                    com = parClass1.getCanonicalName().compareTo(parClass2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(Packet message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(Packet message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(Packet message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

