/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftplus._common.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class InventoryItem
extends InventoryBasic {
    protected final EntityPlayer thePlayer;
    protected final ItemStack theItemStack;
    private boolean isReadingNBT;

    public InventoryItem(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack, int par3) {
        super(par2ItemStack.func_82833_r(), true, par3);
        this.thePlayer = par1EntityPlayer;
        this.theItemStack = par2ItemStack;
        this.func_70295_k_();
    }

    public abstract ItemStack getCurrentItemStack(EntityPlayer var1);

    public void func_70295_k_() {
        if (!InventoryItem.hasInventoryTag(this.theItemStack)) {
            NBTTagCompound nbttag = this.theItemStack.func_77942_o() ? this.theItemStack.func_77978_p() : new NBTTagCompound();
            this.saveInventoryToNBT(nbttag);
            this.theItemStack.func_77982_d(nbttag);
        }
        this.loadInventoryFromNBT(this.theItemStack.func_77978_p());
    }

    public void func_70305_f() {
        this.saveInventory();
    }

    public void saveInventory() {
        this.saveInventoryToNBT(this.theItemStack.func_77978_p());
        if (this.thePlayer.func_71045_bC() != null) {
            InventoryItem.setCopyTagCompound(this.getCurrentItemStack(this.thePlayer), this.theItemStack);
        }
    }

    public void loadInventoryFromNBT(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound != null) {
            int i;
            this.isReadingNBT = true;
            NBTTagList nbttaglist = (NBTTagList)par1NBTTagCompound.func_74775_l("Inventory").func_74781_a("StackItems");
            for (i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, null);
            }
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.func_70302_i_()) continue;
                this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
            this.isReadingNBT = false;
        }
    }

    public NBTTagCompound saveInventoryToNBT(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            NBTTagCompound inventory = new NBTTagCompound();
            inventory.func_74782_a("StackItems", (NBTBase)nbttaglist);
            par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)inventory);
        }
        return par1NBTTagCompound;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.isReadingNBT) {
            this.saveInventory();
        }
    }

    public static boolean hasInventoryTag(ItemStack par1ItemStack) {
        return par1ItemStack.func_77978_p() != null && par1ItemStack.func_77978_p().func_74764_b("Inventory");
    }

    public static void setCopyTagCompound(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        par1ItemStack.func_77982_d(par2ItemStack.func_77978_p());
    }
}

