/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PeripheralCrusher
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getQueueLength", "setEnabled", "isActive", "getInputStack", "getCurrentMaxProgress", "getCurrentProgress", "getMaxEnergyStored", "getEnergyStored"};

    public PeripheralCrusher(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:crusher";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity(TileEntityCrusher.class);
        if (te == null) {
            throw new LuaException("The crusher was removed");
        }
        switch (method) {
            case 0: {
                List<ItemStack> list = te.inputs;
                synchronized (list) {
                    return new Object[]{te.inputs.size()};
                }
            }
            case 1: {
                boolean param;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = param = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
            case 2: {
                return new Object[]{te.active};
            }
            case 3: {
                ItemStack stack;
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int id = (int)((Double)arguments[0]).doubleValue();
                List<ItemStack> list = te.inputs;
                synchronized (list) {
                    if (id < 1 || id > te.inputs.size()) {
                        throw new LuaException("The requested place in the queue does not exist");
                    }
                    stack = te.inputs.get(id - 1);
                }
                return new Object[]{Utils.saveStack(stack)};
            }
            case 4: {
                if (te.inputs.isEmpty()) {
                    throw new LuaException("The crusher doesn't have any inputs");
                }
                int time = te.getRecipeTime(te.inputs.get(0));
                if (time <= 0) {
                    throw new LuaException("The current crusher recipe is invalid");
                }
                return new Object[]{time};
            }
            case 5: {
                if (te.inputs.isEmpty()) {
                    throw new LuaException("The crusher doesn't have any inputs");
                }
                int time = te.getRecipeTime(te.inputs.get(0)) - te.process;
                if (time <= 0) {
                    throw new LuaException("The current crusher recipe is invalid");
                }
                return new Object[]{time};
            }
            case 6: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 7: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityCrusher te = (TileEntityCrusher)this.w.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = true;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityCrusher te = (TileEntityCrusher)this.w.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = false;
    }
}

