/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class IEPotions {
    public static Potion flammable;
    public static Potion slippery;
    public static Potion conductive;
    public static Potion sticky;

    public static void init() {
        int l = 4;
        IEPotions.extendPotionArray(l);
        long potionUUIDBase = 109406000905L;
        int potionID = Config.getPotionID(24, "Flammable");
        flammable = new IEPotion(potionID, true, 9387807, 0, false, 0).func_76390_b("immersiveengineering.potion.flammable");
        potionID = Config.getPotionID(potionID, "Slippery");
        slippery = new IEPotion(potionID, true, 1511427, 0, false, 1).func_76390_b("immersiveengineering.potion.slippery");
        potionID = Config.getPotionID(potionID, "Conductive");
        conductive = new IEPotion(potionID, true, 0x690000, 0, false, 2).func_76390_b("immersiveengineering.potion.conductive");
        potionID = Config.getPotionID(potionID, "Sticky");
        sticky = new IEPotion(potionID, true, 10250240, 0, false, 3).func_76390_b("immersiveengineering.potion.sticky").func_111184_a(SharedMonsterAttributes.field_111263_d, new UUID(potionUUIDBase, 1L).toString(), -0.5000000029802323, 2);
        IEApi.potions = new Potion[]{flammable, slippery, conductive, sticky};
    }

    public static void extendPotionArray(int extendBy) {
        IELogger.info("Attempting to extend PotionArray by " + extendBy);
        Potion[] potions = new Potion[Potion.field_76425_a.length + extendBy];
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            potions[i] = Potion.field_76425_a[i];
        }
        try {
            Field[] fields;
            Field field = null;
            for (Field f : fields = Potion.class.getDeclaredFields()) {
                if (!f.getType().toString().equals("class [Lnet.minecraft.potion.Potion;")) continue;
                field = f;
                break;
            }
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, potions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getNextPotionId(int start) {
        if (Potion.field_76425_a == null) {
            return -2;
        }
        if (start < 0) {
            start = 0;
        }
        int max = Math.min(Potion.field_76425_a.length, 256);
        while (start < max && Potion.field_76425_a[start] != null) {
            ++start;
        }
        if (start >= 256) {
            return -1;
        }
        return start;
    }

    public static class IEPotion
    extends Potion {
        static ResourceLocation tex = new ResourceLocation("immersiveengineering", "textures/gui/potioneffects.png");
        final int tickrate;
        final boolean halfTickRateWIthAmplifier;

        public IEPotion(int id, boolean isBad, int colour, int tick, boolean halveTick, int icon) {
            super(id, isBad, colour);
            this.tickrate = tick;
            this.halfTickRateWIthAmplifier = halveTick;
            this.func_76399_b(icon % 8, icon / 8);
        }

        public int func_76392_e() {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
            return super.func_76392_e();
        }

        public boolean func_76397_a(int duration, int amplifier) {
            if (this.tickrate < 0) {
                return false;
            }
            int k = this.tickrate >> amplifier;
            return k > 0 ? duration % k == 0 : true;
        }

        public void func_76394_a(EntityLivingBase living, int amplifier) {
            if (this == slippery) {
                if (living.field_70122_E) {
                    living.func_70060_a(0.0f, 1.0f, 0.005f);
                }
                if (!living.field_70170_p.field_72995_K && living.func_70681_au().nextInt(300) == 0 && living.func_71124_b(0) != null) {
                    EntityItem dropped = living.func_70099_a(living.func_71124_b(0).func_77946_l(), 1.0f);
                    dropped.field_145804_b = 20;
                    living.func_70062_b(0, null);
                }
            }
        }
    }
}

