/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockCrusher;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESound;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrusher
extends TileEntityMultiblockPart
implements IEnergyReceiver,
ISidedInventory,
IEBlockInterfaces.ISoundTile {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(32000);
    public List<ItemStack> inputs = new ArrayList<ItemStack>();
    public int process = 0;
    public float barrelRotation = 0.0f;
    public boolean active = false;
    public boolean hasPower = false;
    public boolean mobGrinding = false;
    public int grindingTimer = 0;
    public boolean computerControlled;
    public boolean computerOn;
    @SideOnly(value=Side.CLIENT)
    ItemStack particleStack;
    public static final Map<ComparableItemStack, CrusherRecipe> recipeCache = new ConcurrentHashMap<ComparableItemStack, CrusherRecipe>();
    public static final CrusherRecipe CRUSHER_NULL = new CrusherRecipe(null, "", 0);
    static IESound sound;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityCrusher master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityCrusher ? (TileEntityCrusher)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockCrusher.instance.getStructureManual()[this.pos % 15 / 5][this.pos % 5][this.pos / 15];
        return s != null ? s.func_77946_l() : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 17) {
            return;
        }
        if (this.hasPower && this.active && this.process > 0 || this.mobGrinding || this.grindingTimer > 0) {
            if (this.grindingTimer > 0) {
                --this.grindingTimer;
            }
            this.barrelRotation += 18.0f;
            this.barrelRotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound("crusher", this, this.hasPower && (this.active && this.process > 0 || this.mobGrinding || this.grindingTimer > 0), 1.0f, 1.0f);
            if (this.particleStack != null && this.active && this.hasPower && this.process > 0) {
                ImmersiveEngineering.proxy.spawnCrusherFX(this, this.particleStack);
            } else if (this.particleStack != null) {
                this.particleStack = null;
            }
        } else {
            boolean canWork;
            boolean update = false;
            if (this.hasPower != this.energyStorage.getEnergyStored() > 0) {
                this.hasPower = !this.hasPower;
                update = true;
            }
            if (this.computerControlled) {
                canWork = this.computerOn;
            } else {
                boolean bl = canWork = !this.field_145850_b.func_72864_z(this.field_145851_c + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : (this.facing == (this.mirrored ? 2 : 3) ? 2 : -2))), this.field_145848_d + 1, this.field_145849_e + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : (this.facing == (this.mirrored ? 5 : 4) ? 2 : -2))));
            }
            if (canWork) {
                int power = Config.getInt("crusher_consumption");
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5625), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e - 0.5625), (double)((double)this.field_145851_c + 1.5625), (double)((double)this.field_145848_d + 2.875), (double)((double)this.field_145849_e + 1.5625));
                List entityList = this.field_145850_b.func_72872_a(Entity.class, aabb);
                boolean hurtLiving = false;
                if (!entityList.isEmpty() && this.hasPower) {
                    for (Object o : entityList) {
                        EntityItem e;
                        if (o instanceof EntityItem) {
                            e = (EntityItem)o;
                            ItemStack input = e.func_92059_d();
                            if (!this.isValidInput(input)) {
                                e.func_70106_y();
                                this.grindingTimer = 10;
                                update = true;
                                continue;
                            }
                            this.addStackToInputs(input);
                            update = true;
                            e.func_70106_y();
                        }
                        if (!(o instanceof EntityLivingBase)) continue;
                        e = (EntityLivingBase)o;
                        if (!e.field_70128_L && e.func_110143_aJ() > 0.0f) {
                            int consumed = this.energyStorage.extractEnergy(power, false);
                            if (consumed > 0) {
                                e.func_70097_a(IEDamageSources.causeCrusherDamage(), (float)consumed / 20.0f);
                                EventHandler.crusherMap.put(e.func_110124_au(), this);
                                this.mobGrinding = true;
                            }
                            update = true;
                        }
                        hurtLiving = true;
                    }
                }
                if (!hurtLiving && this.process <= 0 && this.mobGrinding) {
                    this.mobGrinding = false;
                    update = true;
                }
                if (this.process > 0) {
                    int consumed = this.energyStorage.extractEnergy(power, false);
                    if (consumed > 0) {
                        this.process -= consumed;
                        if (!this.active) {
                            this.active = true;
                            update = true;
                        }
                    } else if (this.active) {
                        this.active = false;
                        update = true;
                    }
                }
                if (this.process <= 0 && !this.inputs.isEmpty()) {
                    if (this.active) {
                        ItemStack inputStack = this.inputs.get(0);
                        CrusherRecipe recipe = this.getRecipe(inputStack);
                        if (recipe != null) {
                            if (inputStack.field_77994_a >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).field_77994_a : 1)) {
                                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                                ItemStack outputStack = recipe.output;
                                if (outputStack != null) {
                                    out.add(outputStack);
                                }
                                if (recipe.secondaryOutput != null) {
                                    for (int i = 0; i < recipe.secondaryOutput.length; ++i) {
                                        if (!(this.field_145850_b.field_73012_v.nextFloat() < recipe.secondaryChance[i])) continue;
                                        out.add(recipe.secondaryOutput[i]);
                                    }
                                }
                                this.outputItems(out);
                                inputStack.field_77994_a = inputStack.field_77994_a - (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).field_77994_a : 1);
                                if (inputStack.field_77994_a > 0) {
                                    this.inputs.set(0, inputStack);
                                } else {
                                    this.inputs.remove(0);
                                }
                                if (!this.startRecipe()) {
                                    this.active = false;
                                }
                                update = true;
                            } else {
                                this.active = false;
                                update = true;
                            }
                        }
                    } else if (this.startRecipe()) {
                        this.active = true;
                        update = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
                this.mobGrinding = false;
                update = true;
            }
            if (update) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    boolean startRecipe() {
        if (this.inputs.isEmpty()) {
            return false;
        }
        ItemStack inputStack = this.inputs.get(0);
        int time = this.getRecipeTime(inputStack);
        if (time > 0) {
            this.process = time;
        }
        return time > 0;
    }

    public int getRecipeTime(ItemStack in) {
        CrusherRecipe recipe = this.getRecipe(in);
        if (recipe != null && in.field_77994_a >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).field_77994_a : 1)) {
            return recipe.energy;
        }
        return -1;
    }

    public CrusherRecipe getRecipe(ItemStack in) {
        IRockCrusherRecipe crush;
        ComparableItemStack comp = new ComparableItemStack(in.func_77946_l());
        comp.stack.field_77990_d = null;
        comp.stack.field_77994_a = 1;
        comp.useNBT = false;
        comp.ignoreOreDict = true;
        if (recipeCache.containsKey(comp)) {
            CrusherRecipe r = recipeCache.get(comp);
            return r == CRUSHER_NULL ? null : r;
        }
        CrusherRecipe ret = CrusherRecipe.findRecipe(in);
        if (ret == null && RailcraftCraftingManager.rockCrusher != null && (crush = RailcraftCraftingManager.rockCrusher.getRecipe(in)) != null) {
            List<Map.Entry<ItemStack, Float>> out = crush.getOutputs();
            int outCount = out.size();
            float[] outProbabilities = new float[outCount];
            ItemStack[] outStacks = new ItemStack[outCount];
            for (int i = 0; i < outCount; ++i) {
                Map.Entry<ItemStack, Float> entry = out.get(i);
                outProbabilities[i] = entry.getValue().floatValue();
                outStacks[i] = entry.getKey();
            }
            ret = new CrusherRecipe(null, Utils.copyStackWithAmount(in, 1), 4000);
            ret.secondaryChance = outProbabilities;
            ret.secondaryOutput = outStacks;
        }
        if (ret == null) {
            ret = CRUSHER_NULL;
        }
        recipeCache.put(comp, ret);
        return ret == CRUSHER_NULL ? null : ret;
    }

    boolean isValidInput(ItemStack stack) {
        return this.getRecipe(stack) != null;
    }

    public boolean addStackToInputs(ItemStack stack) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (this.inputs.get(i) == null || !this.inputs.get(i).func_77969_a(stack) || this.inputs.get((int)i).field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
            this.inputs.get((int)i).field_77994_a += stack.field_77994_a;
            return true;
        }
        this.inputs.add(stack);
        return true;
    }

    public void outputItems(List<ItemStack> stacks) {
        TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + (this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), this.field_145848_d, this.field_145849_e + (this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)));
        boolean isInv = this.isInventory(inventory, ForgeDirection.OPPOSITES[this.facing]);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack == null) continue;
            if (isInv) {
                stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[this.facing]);
            }
            if (stack == null) continue;
            ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)(fd.offsetX * 2), (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5 + (double)(fd.offsetZ * 2), stack.func_77946_l());
            ei.field_70159_w = 0.075f * (float)fd.offsetX;
            ei.field_70181_x = 0.025000000372529;
            ei.field_70179_y = 0.075f * (float)fd.offsetZ;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).func_94128_d(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.hasPower = nbt.func_74767_n("hasPower");
        if (this.hasPower) {
            this.barrelRotation = nbt.func_74760_g("barrelRotation");
        }
        this.active = nbt.func_74767_n("active");
        this.mobGrinding = nbt.func_74767_n("mobGrinding");
        this.grindingTimer = nbt.func_74762_e("grindingTimer");
        this.process = nbt.func_74762_e("process");
        this.energyStorage.readFromNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = nbt.func_150295_c("inputs", 10);
            this.inputs.clear();
            for (int i = 0; i < invList.func_74745_c(); ++i) {
                this.inputs.add(ItemStack.func_77949_a((NBTTagCompound)invList.func_150305_b(i)));
            }
        } else {
            this.particleStack = nbt.func_74764_b("particleStack") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("particleStack")) : null;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("hasPower", this.hasPower);
        nbt.func_74776_a("barrelRotation", this.barrelRotation);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("mobGrinding", this.mobGrinding);
        nbt.func_74768_a("grindingTimer", this.grindingTimer);
        nbt.func_74768_a("process", this.process);
        this.energyStorage.writeToNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (ItemStack s : this.inputs) {
                invList.func_74742_a((NBTBase)s.func_77955_b(new NBTTagCompound()));
            }
            nbt.func_74782_a("inputs", (NBTBase)invList);
        } else if (!this.inputs.isEmpty()) {
            NBTTagCompound t = this.inputs.get(0).func_77955_b(new NBTTagCompound());
            nbt.func_74782_a("particleStack", (NBTBase)t);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 17 ? AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing == 2 || this.facing == 3 ? 2 : 1)), (double)this.field_145848_d, (double)(this.field_145849_e - (this.facing == 4 || this.facing == 5 ? 2 : 1)), (double)(this.field_145851_c + (this.facing == 2 || this.facing == 3 ? 3 : 2)), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + (this.facing == 4 || this.facing == 5 ? 3 : 2))) : AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        int fl = this.facing;
        int fw = this.facing;
        if (this.mirrored) {
            fw = ForgeDirection.OPPOSITES[fw];
        }
        if (this.pos % 15 >= 6 && this.pos % 15 <= 8) {
            if (this.pos / 15 == 0) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 || fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 || fw == 4 ? 0.1875f : 0.0f, fw == 2 || fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 || fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 ? 0.1875f : 0.0f, fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 || fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 || fw == 5 ? 0.1875f : 0.0f, fw == 3 || fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 || fw == 4 ? 0.8125f : 1.0f};
                }
            } else if (this.pos / 15 == 1) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 ? 0.1875f : 0.0f, 0.5f, fw == 4 ? 0.1875f : 0.0f, fw == 2 ? 0.8125f : 1.0f, 1.0f, fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 ? 0.1875f : 0.0f, 0.5f, fw == 5 ? 0.1875f : 0.0f, fw == 3 ? 0.8125f : 1.0f, 1.0f, fw == 4 ? 0.8125f : 1.0f};
                }
            } else if (this.pos / 15 == 2) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 || fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 || fw == 4 ? 0.1875f : 0.0f, fw == 2 || fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 || fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 ? 0.1875f : 0.0f, fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 || fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 || fw == 5 ? 0.1875f : 0.0f, fw == 3 || fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 || fw == 4 ? 0.8125f : 1.0f};
                }
            }
        } else if (this.pos % 15 >= 11 && this.pos % 15 <= 13) {
            if (this.pos / 15 == 0) {
                if (this.pos % 5 == 2) {
                    float[] fArray = new float[6];
                    fArray[0] = fl == 4 ? 0.1875f : (fl == 5 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fl == 2 ? 0.1875f : (fArray[2] = fl == 3 ? 0.5625f : 0.0f);
                    fArray[3] = fl == 5 ? 0.8125f : (fl == 4 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fl == 3 ? 0.8125f : (fl == 2 ? 0.4375f : 1.0f);
                    return fArray;
                }
            } else if (this.pos / 15 == 1) {
                if (this.pos % 5 == 1) {
                    float[] fArray = new float[6];
                    fArray[0] = fw == 3 ? 0.1875f : (fw == 2 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fw == 4 ? 0.1875f : (fArray[2] = fw == 5 ? 0.5625f : 0.0f);
                    fArray[3] = fw == 2 ? 0.8125f : (fw == 3 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fw == 5 ? 0.8125f : (fw == 4 ? 0.4375f : 1.0f);
                    return fArray;
                }
                if (this.pos % 5 == 2) {
                    return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                }
                if (this.pos % 5 == 3) {
                    float[] fArray = new float[6];
                    fArray[0] = fw == 2 ? 0.1875f : (fw == 3 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fw == 5 ? 0.1875f : (fArray[2] = fw == 4 ? 0.5625f : 0.0f);
                    fArray[3] = fw == 3 ? 0.8125f : (fw == 2 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fw == 4 ? 0.8125f : (fw == 5 ? 0.4375f : 1.0f);
                    return fArray;
                }
            } else if (this.pos / 15 == 2 && this.pos % 5 == 2) {
                float[] fArray = new float[6];
                fArray[0] = fl == 5 ? 0.1875f : (fl == 4 ? 0.5625f : 0.0f);
                fArray[1] = 0.0f;
                float f = fl == 3 ? 0.1875f : (fArray[2] = fl == 2 ? 0.5625f : 0.0f);
                fArray[3] = fl == 4 ? 0.8125f : (fl == 5 ? 0.4375f : 1.0f);
                fArray[4] = 1.0f;
                fArray[5] = fl == 2 ? 0.8125f : (fl == 3 ? 0.4375f : 1.0f);
                return fArray;
            }
        } else {
            if (this.pos == 9) {
                return new float[]{fl == 5 ? 0.5f : 0.0f, 0.0f, fl == 3 ? 0.5f : 0.0f, fl == 4 ? 0.5f : 1.0f, 1.0f, fl == 2 ? 0.5f : 1.0f};
            }
            if (this.pos == 1 || this.pos == 3 || this.pos == 16 || this.pos == 18 || this.pos == 24 || this.pos >= 31 && this.pos <= 34) {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            int il = this.pos / 15;
            int ih = this.pos % 15 / 5 - 1;
            int iw = this.pos % 5 - 2;
            if (this.mirrored) {
                iw = -iw;
            }
            int startX = this.field_145851_c - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.field_145848_d - ih;
            int startZ = this.field_145849_e - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -2; w <= 2; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int ww;
                        int n = ww = this.mirrored ? -w : w;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -ww : ww));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -ww : ww));
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityCrusher) {
                            s = ((TileEntityCrusher)te).getOriginalBlock();
                            ((TileEntityCrusher)te).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed || this.pos != 27) {
            return 0;
        }
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.formed || this.pos != 27) {
            return;
        }
        TileEntityCrusher master = this.master();
        if (master != null) {
            master.addStackToInputs(stack);
        }
    }

    public String func_145825_b() {
        return "IECrusher";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed || this.pos != 27) {
            return false;
        }
        return this.isValidInput(stack);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (this.formed && this.pos == 27 && side == ForgeDirection.UP.ordinal()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.formed && this.pos == 27 && side == ForgeDirection.UP.ordinal();
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 20 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityCrusher master = this.master();
        if (this.formed && master != null && this.pos == 20 && from == ForgeDirection.UP) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityCrusher master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityCrusher master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

