/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlastFurnacePreheater
extends TileEntityIEBase
implements IEnergyReceiver {
    public boolean active;
    public int dummy = 0;
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public int facing = 2;
    public float angle = 0.0f;
    public long lastRenderTick = -1L;

    public boolean canUpdate() {
        return false;
    }

    public int doSpeedup() {
        int consumed = Config.getInt("preheater_consumption");
        if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
            if (!this.active) {
                this.active = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.energyStorage.extractEnergy(consumed, false);
            return 1;
        }
        if (this.active) {
            this.active = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return 0;
    }

    public void turnOff() {
        this.active = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74762_e("dummy");
        this.facing = nbt.func_74762_e("facing");
        this.energyStorage.readFromNBT(nbt);
        this.active = nbt.func_74767_n("active");
        if (descPacket) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("active", this.active);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.UP && this.dummy == 2;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.dummy > 0) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.dummy, this.field_145849_e);
            if (te instanceof TileEntityBlastFurnacePreheater) {
                return ((TileEntityBlastFurnacePreheater)te).receiveEnergy(from, maxReceive, simulate);
            }
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.dummy > 0) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.dummy, this.field_145849_e);
            if (te instanceof TileEntityBlastFurnacePreheater) {
                return ((TileEntityBlastFurnacePreheater)te).getEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.dummy > 0) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.dummy, this.field_145849_e);
            if (te instanceof TileEntityBlastFurnacePreheater) {
                return ((TileEntityBlastFurnacePreheater)te).getMaxEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

