/*
 * Decompiled with CFR 0.152.
 */
package emt.tile.solar;

import emt.tile.TileEntityEMT;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.tile.IWrenchable;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntitySolarBase
extends TileEntityEMT
implements IWrenchable {
    public BasicSource energySource = new BasicSource((TileEntity)this, 10000.0, 4);
    public static Random random = new Random();
    public boolean initialized;
    public boolean theSunIsVisible;
    public boolean canRain;
    public boolean noSunlight;
    public int tick = random.nextInt(64);
    public double output = 0.0;

    public void func_145845_h() {
        this.energySource.func_145845_h();
        this.checkConditions();
    }

    public void checkConditions() {
        if (!this.initialized && this.field_145850_b != null) {
            this.canRain = this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e).func_76744_g() > 0;
            this.noSunlight = this.field_145850_b.field_73011_w.field_76576_e;
            this.initialized = true;
        }
        if (this.noSunlight) {
            return;
        }
        if (this.tick-- == 0) {
            this.updateSunState();
            this.tick = 64;
        }
        this.createEnergy();
    }

    public void createEnergy() {
        if (this.theSunIsVisible) {
            this.energySource.addEnergy(this.output);
        }
    }

    public void updateSunState() {
        boolean isRaining = this.canRain && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.theSunIsVisible = this.field_145850_b.func_72935_r() && !isRaining && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public void onChunkUnload() {
        this.energySource.onChunkUnload();
    }

    public void func_145843_s() {
        this.energySource.func_145843_s();
        super.func_145843_s();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.energySource.func_145841_b(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energySource.func_145839_a(nbttagcompound);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }
}

