/*
 * Decompiled with CFR 0.152.
 */
package emt.item.tool.chainsaw;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemDiamondChainsaw
extends ItemAxe
implements IElectricItem {
    public int maxCharge = 40000;
    public int cost = 200;
    public int hitCost = 300;
    public int tier = 2;

    public ItemDiamondChainsaw() {
        super(Item.ToolMaterial.EMERALD);
        this.field_77864_a = 16.0f;
        this.func_77637_a(EMT.TAB);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("emt:tools/chainsaw_diamond");
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int par4, int par5, int par6, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, (double)this.cost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(block, stack) || Items.field_151048_u.canHarvestBlock(block, stack) || Items.field_151097_aZ.canHarvestBlock(block, stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(stack, (double)this.cost)) {
            return 1.0f;
        }
        if (Items.field_151053_p.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151041_m.getDigSpeed(stack, block, meta) > 1.0f) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (ElectricItem.manager.use(itemstack, (double)this.hitCost, attacker)) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 12.0f);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !((item = torchStack.func_77973_b()) instanceof ItemBlock) || !(Block.func_149634_a((Item)item) instanceof BlockTorch)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!IC2.platform.isSimulating()) {
            return super.func_77659_a(stack, world, player);
        }
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            if (!nbt.func_74764_b("shearsMode")) {
                nbt.func_74757_a("shearsMode", true);
            }
            if (!nbt.func_74767_n("shearsMode")) {
                nbt.func_74757_a("shearsMode", true);
                IC2.platform.messagePlayer(player, "ic2.tooltip.mode", new Object[]{"ic2.tooltip.mode.normal"});
            } else {
                nbt.func_74757_a("shearsMode", false);
                IC2.platform.messagePlayer(player, "ic2.tooltip.mode", new Object[]{"ic2.tooltip.mode.noShear"});
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (!nbt.func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
        if (!nbt.func_74767_n("shearsMode") || player.field_70170_p.field_72995_K) {
            return false;
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double xOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double yOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double zOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (!nbt.func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
        if (!nbt.func_74767_n("shearsMode") || entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean flag) {
        NBTTagCompound nbt;
        if (entity instanceof EntityLivingBase && !(nbt = StackUtil.getOrCreateNbtData((ItemStack)stack)).func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EMTConfigHandler.enchanting;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 300.0;
    }
}

