/*
 * Decompiled with CFR 0.152.
 */
package emt.item.armor.goggles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.item.armor.goggles.ItemNanoGoggles;
import emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemQuantumGoggles
extends ItemNanoGoggles {
    private static final Map<Integer, Integer> potionCost = new HashMap<Integer, Integer>();

    public ItemQuantumGoggles(ItemArmor.ArmorMaterial material, int renderIndex, int armorType) {
        super(material, renderIndex, armorType);
        this.func_77637_a(EMT.TAB);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.maxCharge = 1.0E7;
        this.tier = 3;
        this.visDiscount = 8;
        this.transferLimit = 10000.0;
        this.energyPerDamage = 1000;
        potionCost.put(Potion.field_76436_u.field_76415_H, 10000);
        potionCost.put(Potion.field_82731_v.field_76415_H, 15000);
        potionCost.put(Potion.field_76431_k.field_76415_H, 5000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("emt:armor/goggles_quantum");
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "emt:textures/models/thaumicquantumhelmet.png";
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int refill = player.func_70086_ai();
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && refill < 100) {
            player.func_70050_g(refill + 200);
            ElectricItem.manager.use(itemStack, 1000.0, null);
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            int id = effect.func_76456_a();
            Integer cost = potionCost.get(id);
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
            ItemStack milk = new ItemStack(Items.field_151117_aB);
            player.curePotionEffects(milk);
        }
        if (!EMTConfigHandler.nightVisionOff) {
            if (ElectricItem.manager.canUse(itemStack, 0.0)) {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int lightlevel = player.field_70170_p.func_72957_l(x, y, z);
                if (lightlevel >= 0) {
                    player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, -3));
                }
                ElectricItem.manager.use(itemStack, 0.0, (EntityLivingBase)player);
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300, 0, true));
            }
        }
    }
}

