/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NativeFileImporter
implements IImporter {
    public static final NativeFileImporter INSTANCE = new NativeFileImporter();
    private static final FileFilter FILTER = new FileExtensionFilter(".json");

    public String getUnlocalisedName() {
        return "bq_standard.importer.nat_file.name";
    }

    public String getUnlocalisedDescription() {
        return "bq_standard.importer.nat_file.desc";
    }

    public FileFilter getFileFilter() {
        return FILTER;
    }

    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        for (File selected : files) {
            if (selected == null || !selected.exists()) continue;
            NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object((JsonObject)JsonHelper.ReadFromFile((File)selected), (NBTTagCompound)new NBTTagCompound(), (boolean)true);
            HashMap<Integer, Integer> remappedIDs = this.readQuests(nbt.func_150295_c("questDatabase", 10), questDB);
            this.readQuestLines(nbt.func_150295_c("questLines", 10), lineDB, remappedIDs);
        }
    }

    private HashMap<Integer, Integer> readQuests(NBTTagList json, IQuestDatabase questDB) {
        HashMap<Integer, Integer> remappedIDs = new HashMap<Integer, Integer>();
        ArrayList<IQuest> loadedQuests = new ArrayList<IQuest>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int oldID;
            NBTTagCompound qTag = json.func_150305_b(i);
            int n = oldID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (oldID < 0) continue;
            int qID = questDB.nextID();
            IQuest quest = questDB.createNew(qID);
            quest.readFromNBT((NBTBase)qTag);
            remappedIDs.put(oldID, qID);
            loadedQuests.add(quest);
        }
        for (IQuest quest : loadedQuests) {
            int[] oldIDs = Arrays.copyOf(quest.getRequirements(), quest.getRequirements().length);
            for (int n = 0; n < oldIDs.length; ++n) {
                if (!remappedIDs.containsKey(oldIDs[n])) continue;
                oldIDs[n] = remappedIDs.get(oldIDs[n]);
            }
            quest.setRequirements(oldIDs);
        }
        return remappedIDs;
    }

    private void readQuestLines(NBTTagList json, IQuestLineDatabase lineDB, HashMap<Integer, Integer> remappeIDs) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jql = (NBTTagCompound)json.func_150305_b(i).func_74737_b();
            if (jql.func_150297_b("quests", 9)) {
                NBTTagList qList = jql.func_150295_c("quests", 10);
                for (int n = 0; n < qList.func_74745_c(); ++n) {
                    int oldID;
                    NBTTagCompound qTag = qList.func_150305_b(n);
                    int n2 = oldID = qTag.func_150297_b("id", 99) ? qTag.func_74762_e("id") : -1;
                    if (oldID < 0) continue;
                    Integer qID = remappeIDs.get(oldID);
                    qTag.func_74768_a("id", qID.intValue());
                }
            }
            IQuestLine ql = lineDB.createNew(lineDB.nextID());
            ql.readFromNBT((NBTBase)jql);
        }
    }
}

