/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;

public final class MathsUtils {
    static ArrayList<Integer> foundEnchantments = new ArrayList();
    static ArrayList<Integer> foundBiomes = new ArrayList();
    static ArrayList<Integer> foundPotions = new ArrayList();

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? new BigDecimal(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(int min, int max) {
        return Constants.RANDOM.nextInt(max - min + 1) + min;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, double length) {
        Vec3 vec1 = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 vec2 = player.func_70040_Z();
        Vec3 vec3 = vec1.func_72441_c(vec2.field_72450_a * length, vec2.field_72448_b * length, vec2.field_72449_c * length);
        return player.field_70170_p.func_72933_a(vec1, vec3);
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getRandomColor() {
        return new Color(Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat()).getRGB();
    }

    public static int getAvailableBiomeID() {
        for (int possibleID = 0; possibleID < BiomeGenBase.func_150565_n().length; ++possibleID) {
            if (BiomeGenBase.func_150568_d((int)possibleID) != null || foundBiomes.contains(possibleID)) continue;
            foundBiomes.add(possibleID);
            return possibleID;
        }
        throw new RuntimeException("An attempt to find an available biome ID was made, however no IDs are available.");
    }

    public static int getNextEnchantmentID() {
        for (int possibleID = 0; possibleID < Enchantment.field_77331_b.length; ++possibleID) {
            if (Enchantment.field_77331_b[possibleID] != null || foundEnchantments.contains(possibleID)) continue;
            foundEnchantments.add(possibleID);
            return possibleID;
        }
        throw new RuntimeException("An attempt to find an available enchantment ID was made, however no IDs are available.");
    }

    public static int getNextPotionID() {
        for (int possibleID = 0; possibleID < Potion.field_76425_a.length; ++possibleID) {
            if (Potion.field_76425_a[possibleID] != null || foundPotions.contains(possibleID) || possibleID <= 32) continue;
            foundPotions.add(possibleID);
            return possibleID;
        }
        throw new RuntimeException("An attempt to find an available potion ID was made, however no IDs are available.");
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }
}

