/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class Position
implements Comparable<Position>,
Serializable {
    private final int x;
    private final int y;
    private final int z;

    public Position(MovingObjectPosition pos) {
        this(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
    }

    public Position(Entity entity) {
        this((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
    }

    public Position(NBTTagCompound tag) {
        this(tag.func_74762_e("positionX"), tag.func_74762_e("positionY"), tag.func_74762_e("positionZ"));
    }

    public Position(DataInputStream inputStream) throws IOException {
        this(inputStream.readInt(), inputStream.readInt(), inputStream.readInt());
    }

    public Position(ByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public Position(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void write(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(this.x);
        dataStream.writeInt(this.y);
        dataStream.writeInt(this.z);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74768_a("positionX", this.x);
        tag.func_74768_a("positionY", this.y);
        tag.func_74768_a("positionZ", this.z);
        return tag;
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public Position offset(int direction) {
        return this.offset(direction, 1);
    }

    public Position offset(int direction, int amount) {
        switch (direction) {
            case 0: {
                return this.translateDown(amount);
            }
            case 1: {
                return this.translateUp(amount);
            }
            case 2: {
                return this.translateNorth(amount);
            }
            case 3: {
                return this.translateSouth(amount);
            }
            case 4: {
                return this.translateWest(amount);
            }
            case 5: {
                return this.translateEast(amount);
            }
        }
        return this.translateDown(amount);
    }

    public Position translate(int x, int y, int z) {
        return new Position(this.x + x, this.y + y, this.z + z);
    }

    public Position translateUp() {
        return new Position(this.x, this.y + 1, this.z);
    }

    public Position translateUp(int distance) {
        return new Position(this.x, this.y + distance, this.z);
    }

    public Position translateDown() {
        return new Position(this.x, this.y - 1, this.z);
    }

    public Position translateDown(int distance) {
        return new Position(this.x, this.y - distance, this.z);
    }

    public Position translateNorth() {
        return new Position(this.x, this.y, this.z - 1);
    }

    public Position translateNorth(int distance) {
        return new Position(this.x, this.y, this.z - distance);
    }

    public Position translateSouth() {
        return new Position(this.x, this.y, this.z + 1);
    }

    public Position translateSouth(int distance) {
        return new Position(this.x, this.y, this.z + distance);
    }

    public Position translateWest() {
        return new Position(this.x - 1, this.y, this.z);
    }

    public Position translateWest(int distance) {
        return new Position(this.x - distance, this.y, this.z);
    }

    public Position translateEast() {
        return new Position(this.x + 1, this.y, this.z);
    }

    public Position translateEast(int distance) {
        return new Position(this.x + distance, this.y, this.z);
    }

    public double getDistance(Position pos) {
        return this.getDistance(pos.x, pos.y, pos.z);
    }

    public double getDistance(int x, int y, int z) {
        int distanceX = this.x - x;
        int distanceY = this.y - y;
        int distanceZ = this.z - z;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public boolean isBlockAtPosition(World world) {
        return this.getBlockAtPosition(world) != null;
    }

    public Block getBlockAtPosition(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public void setBlockAtPosition(World world, Block block) {
        world.func_147449_b(this.x, this.y, this.z, block);
    }

    public void setBlockAtPositionToAir(World world) {
        world.func_147468_f(this.x, this.y, this.z);
    }

    public int getMetaAtPosition(World world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public void setMetaAtPosition(World world, int meta) {
        world.func_72921_c(this.x, this.y, this.z, meta, 2);
    }

    public void sendEntityToPosition(EntityLivingBase entity) {
        entity.func_70634_a((double)this.x, (double)this.y, (double)this.z);
    }

    public Object clone() {
        return new Position(this.x, this.y, this.z);
    }

    public boolean equals(Object compared) {
        if (!(compared instanceof Position)) {
            return false;
        }
        Position p = (Position)compared;
        return this.x == p.x && this.y == p.y && this.z == p.z;
    }

    public int hashCode() {
        return this.y & 0xFF | (this.x & Short.MAX_VALUE) << 8 | (this.z & Short.MAX_VALUE) << 24 | (this.x < 0 ? Integer.MIN_VALUE : 0) | (this.z < 0 ? 32768 : 0);
    }

    @Override
    public int compareTo(Position pos) {
        return this.y == pos.y ? (this.z == pos.z ? this.x - pos.x : this.z - pos.z) : this.y - pos.y;
    }

    public String toString() {
        return "X: " + this.x + " Y:" + this.y + " Z:" + this.z;
    }
}

