/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.common.EntityProperties;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketAddPlayerProperties
extends AbstractMessage<PacketAddPlayerProperties> {
    private BuffEffect buffs = null;
    private int entityId;

    public PacketAddPlayerProperties() {
    }

    public PacketAddPlayerProperties(EntityLivingBase entity, BuffEffect buff) {
        this.buffs = buff;
        this.entityId = entity.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.buffs = BuffEffect.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        NBTTagCompound compound = new NBTTagCompound();
        this.buffs.writeToNBT(compound);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    @Override
    public void handleClientMessage(PacketAddPlayerProperties message, EntityPlayer player) {
        Entity entity;
        if (player != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.entityId)) != null && entity instanceof EntityLivingBase) {
            EntityProperties.getProperties((EntityLivingBase)entity).add(message.buffs, true);
        }
    }

    @Override
    public void handleServerMessage(PacketAddPlayerProperties message, EntityPlayer player) {
    }
}

