/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.darkhax.bookshelf.buff.Buff;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BookshelfRegistry {
    private static final List<AnvilRecipe> anvilRecipes = new ArrayList<AnvilRecipe>();
    public static BiMap<String, Buff> buffMap = HashBiMap.create();
    public static HashMap<ItemStack, ArrayList<String>> infoMap = new HashMap();

    public static void addAnvilRecipe(ItemStack inputLeft, ItemStack inputRight, int experience, ItemStack output) {
        anvilRecipes.add(new AnvilRecipe(inputLeft, inputRight, experience, output));
    }

    public static void addAnvilRecipe(ItemStack inputLeft, ItemStack inputRight, String requiredName, int experience, ItemStack output) {
        anvilRecipes.add(new AnvilRecipe(inputLeft, inputRight, requiredName, experience, 0, output));
    }

    public static void addAnvilRecipe(ItemStack inputLeft, ItemStack inputRight, String requiredName, int experience, int materialCost, ItemStack output) {
        anvilRecipes.add(new AnvilRecipe(inputLeft, inputRight, requiredName, experience, materialCost, output));
    }

    public void addAnvilRecipe(AnvilRecipe recipe) {
        anvilRecipes.add(recipe);
    }

    public static List<AnvilRecipe> getAnvilRecipes() {
        return anvilRecipes;
    }

    public static Buff getBuffFromString(String name) {
        return buffMap.containsKey((Object)name) ? (Buff)buffMap.get((Object)name) : null;
    }

    public static void registerBuff(Buff buff) {
        if (buffMap.containsKey((Object)buff.getPotionName())) {
            throw new RuntimeException("An attempt was made to register a Potion with the name of " + buff.getPotionName() + " however it is already in use. " + ((Buff)buffMap.get((Object)buff.getPotionName())).getClass().getName() + " " + buff.getClass().getName());
        }
        buffMap.put((Object)buff.getPotionName(), (Object)buff);
    }

    public static void addInformation(Item item) {
        BookshelfRegistry.addInformation(item, "info." + item.func_77658_a().substring(5));
    }

    public static void addInformation(Item item, String localizationKey) {
        BookshelfRegistry.addInformation(new ItemStack(item), localizationKey);
    }

    public static void addInformation(Block block) {
        BookshelfRegistry.addInformation(block, "info." + block.func_149739_a().substring(5));
    }

    public static void addInformation(Block block, String localizationKey) {
        BookshelfRegistry.addInformation(new ItemStack(block), localizationKey);
    }

    public static void addInformation(ItemStack stack, String localizationKey) {
        for (ItemStack keyStack : infoMap.keySet()) {
            if (!ItemStackUtils.areStacksSimilar(keyStack, stack)) continue;
            infoMap.get(keyStack).add(localizationKey);
            return;
        }
        ArrayList<String> infoKeys = new ArrayList<String>();
        infoKeys.add(localizationKey);
        infoMap.put(stack, infoKeys);
    }

    public static boolean doesStackHaveDescription(ItemStack stack) {
        for (ItemStack keyStack : infoMap.keySet()) {
            if (!ItemStackUtils.areStacksSimilar(keyStack, stack)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> getDescriptionKeys(ItemStack stack) {
        for (ItemStack keyStack : infoMap.keySet()) {
            if (!ItemStackUtils.areStacksSimilar(keyStack, stack)) continue;
            return infoMap.get(keyStack);
        }
        return null;
    }

    public static class AnvilRecipe {
        public ItemStack inputLeft;
        public ItemStack inputRight;
        public String nameTaxt;
        public int experienceUsed;
        public int materialCost;
        public ItemStack output;

        public AnvilRecipe(ItemStack firstInput, ItemStack secondInput, int experience, ItemStack outputStack) {
            this(firstInput, secondInput, null, experience, 0, outputStack);
        }

        public AnvilRecipe(ItemStack firstInput, ItemStack secondInput, String requiredName, int experience, int materialCost, ItemStack outputStack) {
            this.inputLeft = firstInput;
            this.inputRight = secondInput;
            this.nameTaxt = requiredName;
            this.experienceUsed = experience;
            this.materialCost = materialCost;
            this.output = outputStack;
        }

        public int getExperienceCost(ItemStack firstInput, ItemStack secondInput, String enteredName) {
            return this.experienceUsed;
        }

        public int getMaterialCost(ItemStack firstInput, ItemStack secondInput, String enteredName) {
            return this.inputRight.field_77994_a;
        }

        public ItemStack getOutput(ItemStack firstInput, ItemStack secondInput, String enteredName) {
            return this.output.func_77946_l();
        }
    }
}

