/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.darkhax.bookshelf.asm.ASMHelper;
import net.darkhax.bookshelf.buff.Buff;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.buff.BuffHelper;
import net.darkhax.bookshelf.items.ItemHorseArmor;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.lwjgl.opengl.GL11;

public class RenderingHandler {
    private static final ResourceLocation INVENTORY_TEXTURES = new ResourceLocation("textures/gui/container/inventory.png");

    @SubscribeEvent
    public void onOverlayRender(GuiScreenEvent.DrawScreenEvent event) {
        if (event.gui != null && event.gui instanceof InventoryEffectRenderer) {
            InventoryEffectRenderer gui = (InventoryEffectRenderer)event.gui;
            int i = RenderUtils.getGuiLeft((GuiContainer)gui) - 124;
            int j = RenderUtils.getGuiTop((GuiContainer)gui);
            EntityClientPlayerMP player = gui.field_146297_k.field_71439_g;
            List<BuffEffect> effects = BuffHelper.getEntityEffects((EntityLivingBase)player);
            if (!effects.isEmpty()) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                int yOffset = 33;
                int totalSize = effects.size() + player.func_70651_bq().size();
                if (player.func_70651_bq().size() > 5) {
                    yOffset = 132 / (totalSize - 1);
                }
                j += yOffset * (totalSize - 1);
                FontRenderer fnt = gui.field_146297_k.field_71466_p;
                for (BuffEffect buffEffect : effects) {
                    Buff buff = buffEffect.getBuff();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.field_146297_k.func_110434_K().func_110577_a(INVENTORY_TEXTURES);
                    gui.func_73729_b(i, j, 0, 166, 140, 32);
                    buff.renderInventoryEffect(i, j, buffEffect, gui.field_146297_k);
                    if (buff.shouldRenderInvText(buffEffect)) {
                        String s1 = buff.getTranslatedName();
                        if (buffEffect.power > 1) {
                            s1 = s1 + " " + StatCollector.func_74838_a((String)("enchantment.level." + buffEffect.power));
                        }
                        fnt.func_78261_a(s1, i + 10 + 18, j + 6, 0xFFFFFF);
                        fnt.func_78261_a(StringUtils.func_76337_a((int)buffEffect.duration), i + 10 + 18, j + 6 + 10, 0x7F7F7F);
                    }
                    j += yOffset;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityRender(RenderLivingEvent.Pre event) {
        this.triggerRenderHook((RenderLivingEvent)event, (byte)0);
    }

    @SubscribeEvent
    public void onEntityRender(RenderLivingEvent.Post event) {
        this.triggerRenderHook((RenderLivingEvent)event, (byte)1);
    }

    @SubscribeEvent
    public void onEntityRender(RenderLivingEvent.Specials.Pre event) {
        this.triggerRenderHook((RenderLivingEvent)event, (byte)2);
    }

    @SubscribeEvent
    public void onEntityRender(RenderLivingEvent.Specials.Post event) {
        this.triggerRenderHook((RenderLivingEvent)event, (byte)3);
    }

    public void triggerRenderHook(RenderLivingEvent event, byte flag) {
        EntityHorse horse;
        ItemStack customArmor;
        if (!ASMHelper.isASMEnabled) {
            Constants.LOG.warn("The ASM has not been initialized, there is an error with your setup!");
        } else if (event.entity instanceof EntityHorse && (customArmor = Utilities.getCustomHorseArmor(horse = (EntityHorse)event.entity)) != null && customArmor.func_77973_b() instanceof ItemHorseArmor) {
            ItemHorseArmor armor = (ItemHorseArmor)customArmor.func_77973_b();
            armor.onHorseRendered(horse, customArmor, event, flag);
        }
    }
}

