/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import gnu.trove.impl.unmodifiable.TUnmodifiableLongObjectMap;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import wanion.unidict.resource.UniResourceContainer;

public class Resource {
    private static final TObjectLongMap<String> nameToKind = new TObjectLongHashMap();
    private static final TLongObjectMap<String> kindToName = new TLongObjectHashMap();
    private static int totalKindsRegistered = 0;
    private static boolean populated;
    public final String name;
    private final TLongObjectMap<UniResourceContainer> childrenMap = new TLongObjectHashMap();
    private final List<Resource> copies = new ArrayList<Resource>();
    private long children = 0L;
    private boolean updated;
    private boolean sorted = false;

    public Resource(@Nonnull String name) {
        this.name = name;
    }

    public Resource(@Nonnull String name, @Nonnull TLongObjectMap<UniResourceContainer> containerMap) {
        this.name = name;
        containerMap.forEachValue(container -> {
            this.children |= container.kind;
            return this.childrenMap.put(container.kind, container) == null;
        });
    }

    public long getChildren() {
        return this.children;
    }

    public UniResourceContainer getChild(@Nonnull String childName) {
        return (UniResourceContainer)this.childrenMap.get(nameToKind.get((Object)childName));
    }

    public UniResourceContainer getChild(long kind) {
        return (UniResourceContainer)this.childrenMap.get(kind);
    }

    public Resource filteredClone(long kinds) {
        TLongObjectHashMap newChildrenMap = new TLongObjectHashMap();
        this.childrenMap.forEachEntry((arg_0, arg_1) -> Resource.lambda$filteredClone$1(kinds, (TLongObjectMap)newChildrenMap, arg_0, arg_1));
        Resource copiedResource = new Resource(this.name, (TLongObjectMap<UniResourceContainer>)newChildrenMap);
        this.copies.add(copiedResource);
        return copiedResource;
    }

    public boolean addChild(@Nonnull UniResourceContainer child) {
        long kind = child.kind;
        if ((this.children & kind) > 0L || !child.name.endsWith(this.name)) {
            return false;
        }
        this.children |= kind;
        this.childrenMap.put(kind, (Object)child);
        return true;
    }

    public void updateEntries() {
        if (this.updated) {
            return;
        }
        this.updated = true;
        TLongIterator childrenIterator = this.childrenMap.keySet().iterator();
        while (childrenIterator.hasNext()) {
            long kindId = childrenIterator.next();
            if (((UniResourceContainer)this.childrenMap.get(kindId)).updateEntries()) continue;
            this.children &= kindId ^ 0xFFFFFFFFFFFFFFFFL;
            childrenIterator.remove();
        }
        this.copies.forEach(Resource::updateEntries);
    }

    public Collection<UniResourceContainer> getChildrenCollection() {
        return this.childrenMap.valueCollection();
    }

    public String toString() {
        if (this.childrenMap.isEmpty()) {
            return this.name + " = {}";
        }
        StringBuilder output = new StringBuilder(this.name + " = {");
        TLongIterator childrenIterator = this.childrenMap.keySet().iterator();
        while (childrenIterator.hasNext()) {
            output.append((String)kindToName.get(childrenIterator.next())).append(childrenIterator.hasNext() ? ", " : "}");
        }
        return output.toString();
    }

    TLongObjectMap<UniResourceContainer> getChildrenMap() {
        return new TUnmodifiableLongObjectMap(this.childrenMap);
    }

    Resource setSortOfChildren(boolean sort) {
        this.childrenMap.forEachValue(child -> {
            child.setSort(sort);
            return true;
        });
        return this;
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, String ... kinds) {
        long kindsId = 0L;
        for (String kind : kinds) {
            long kindId = Resource.getKindOfName(kind);
            if (kindId == 0L) {
                return Collections.emptyList();
            }
            kindsId |= kindId;
        }
        return Resource.getResources(resources, kindsId);
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, long kinds) {
        return kinds != 0L ? resources.stream().filter(resource -> (kinds & resource.getChildren()) == kinds).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static List<Resource> getResources(@Nonnull Collection<Resource> resources, long ... kinds) {
        long trueKinds = 0L;
        for (long kind : kinds) {
            if (kind != 0L) {
                trueKinds |= kind;
                continue;
            }
            return Collections.emptyList();
        }
        return Resource.getResources(resources, trueKinds);
    }

    public static List<String> getKinds() {
        return Collections.unmodifiableList(new ArrayList(nameToKind.keySet()));
    }

    public static long getKindOfName(@Nonnull String name) {
        return nameToKind.get((Object)name);
    }

    public static String getNameOfKind(long kind) {
        return (String)kindToName.get(kind);
    }

    public static boolean kindExists(@Nonnull String name) {
        return nameToKind.containsKey((Object)name);
    }

    public static boolean kindExists(String ... names) {
        for (String name : names) {
            if (nameToKind.containsKey((Object)name)) continue;
            return false;
        }
        return true;
    }

    static void register(@Nonnull String kindName) {
        if (nameToKind.containsKey((Object)kindName)) {
            return;
        }
        int kind = 1 << totalKindsRegistered++;
        nameToKind.put((Object)kindName, (long)kind);
        kindToName.put((long)kind, (Object)kindName);
    }

    static long registerAndGet(@Nonnull String kindName) {
        if (nameToKind.containsKey((Object)kindName)) {
            return nameToKind.get((Object)kindName);
        }
        int kind = 1 << totalKindsRegistered++;
        nameToKind.put((Object)kindName, (long)kind);
        kindToName.put((long)kind, (Object)kindName);
        return kind;
    }

    private static /* synthetic */ boolean lambda$filteredClone$1(long kinds, TLongObjectMap newChildrenMap, long child, UniResourceContainer container) {
        if ((child & kinds) > 0L) {
            newChildrenMap.put(child, (Object)container);
        }
        return true;
    }
}

