/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.multiblock.MultiblockManager;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.blocks.BlockCoreType;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.blocks.BlockResourceOre;
import forestry.core.blocks.BlockResourceStorage;
import forestry.core.blocks.BlockSoil;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.SolderManager;
import forestry.core.commands.CommandPlugins;
import forestry.core.commands.CommandVersion;
import forestry.core.commands.RootCommand;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.genetics.alleles.AlleleFactory;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AlleleRegistry;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemRegistryCore;
import forestry.core.multiblock.MultiblockLogicFactory;
import forestry.core.network.IPacketRegistry;
import forestry.core.network.PacketRegistryCore;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginFluids;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.core.description")
public class PluginCore
extends ForestryPlugin {
    public static final RootCommand rootCommand = new RootCommand();
    public static ItemRegistryCore items;
    public static BlockRegistryCore blocks;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        ChipsetManager.solderManager = new SolderManager();
        ChipsetManager.circuitRegistry = new CircuitRegistry();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        AlleleManager.climateHelper = new ClimateUtil();
        AlleleManager.alleleFactory = new AlleleFactory();
        alleleRegistry.initialize();
        AlleleHelper.instance = new AlleleHelper();
        MultiblockManager.logicFactory = new MultiblockLogicFactory();
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryCore();
        blocks = new BlockRegistryCore();
    }

    @Override
    public void preInit() {
        super.preInit();
        rootCommand.addChildCommand(new CommandVersion());
        rootCommand.addChildCommand(new CommandPlugins());
        PluginCore.blocks.core.addDefinitions(new MachineDefinition(BlockCoreType.ESCRITOIRE), new MachineDefinition(BlockCoreType.ANALYZER));
    }

    @Override
    public void doInit() {
        super.doInit();
        Proxies.render.init();
        PluginCore.blocks.core.init();
        ForestryModEnvWarningCallable.register();
        AlleleHelper.instance.init();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(PluginCore.items.peat, "cratedPeat");
        crateRegistry.registerCrate(PluginCore.items.apatite, "cratedApatite");
        crateRegistry.registerCrate(PluginCore.items.fertilizerCompound, "cratedFertilizer");
        crateRegistry.registerCrate(PluginCore.items.mulch, "cratedMulch");
        crateRegistry.registerCrate(PluginCore.items.phosphor, "cratedPhosphor");
        crateRegistry.registerCrate(PluginCore.items.ash, "cratedAsh");
        crateRegistry.registerCrateUsingOreDict(PluginCore.items.ingotTin, "cratedTin");
        crateRegistry.registerCrateUsingOreDict(PluginCore.items.ingotCopper, "cratedCopper");
        crateRegistry.registerCrateUsingOreDict(PluginCore.items.ingotBronze, "cratedBronze");
        crateRegistry.registerCrate(PluginCore.blocks.soil.get(BlockSoil.SoilType.HUMUS, 1), "cratedHumus");
        crateRegistry.registerCrate(PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 1), "cratedBogearth");
        crateRegistry.registerCrate(Items.field_151015_O, "cratedWheat");
        crateRegistry.registerCrate(Items.field_151106_aX, "cratedCookies");
        crateRegistry.registerCrate(Items.field_151137_ax, "cratedRedstone");
        crateRegistry.registerCrate(new ItemStack(Items.field_151100_aR, 1, 4), "cratedLapis");
        crateRegistry.registerCrate(Items.field_151120_aE, "cratedReeds");
        crateRegistry.registerCrate(Items.field_151119_aD, "cratedClay");
        crateRegistry.registerCrate(Items.field_151114_aO, "cratedGlowstone");
        crateRegistry.registerCrate(Items.field_151034_e, "cratedApples");
        crateRegistry.registerCrate(new ItemStack(Items.field_151075_bm), "cratedNetherwart");
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 1), "cratedCharcoal");
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 0), "cratedCoal");
        crateRegistry.registerCrate(Items.field_151014_N, "cratedSeeds");
        crateRegistry.registerCrate(Items.field_151174_bG, "cratedPotatoes");
        crateRegistry.registerCrate(Items.field_151172_bF, "cratedCarrots");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 0), "cratedWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 1), "cratedSpruceWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 2), "cratedBirchWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 3), "cratedJungleWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 0), "cratedAcaciaWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 1), "cratedDarkOakWood");
        crateRegistry.registerCrate(Blocks.field_150347_e, "cratedCobblestone");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150346_d, 1, 0), "cratedDirt");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150346_d, 1, 2), "cratedPodzol");
        crateRegistry.registerCrate(Blocks.field_150348_b, "cratedStone");
        crateRegistry.registerCrate(Blocks.field_150336_V, "cratedBrick");
        crateRegistry.registerCrate(Blocks.field_150434_aF, "cratedCacti");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 0), "cratedSand");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 1), "cratedRedSand");
        crateRegistry.registerCrate(Blocks.field_150343_Z, "cratedObsidian");
        crateRegistry.registerCrate(Blocks.field_150424_aL, "cratedNetherrack");
        crateRegistry.registerCrate(Blocks.field_150425_aM, "cratedSoulsand");
        crateRegistry.registerCrate(Blocks.field_150322_A, "cratedSandstone");
        crateRegistry.registerCrate(Blocks.field_150385_bj, "cratedNetherbrick");
        crateRegistry.registerCrate((Block)Blocks.field_150391_bh, "cratedMycelium");
        crateRegistry.registerCrate(Blocks.field_150351_n, "cratedGravel");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 0), "cratedSaplings");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 1), "cratedSpruceSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 2), "cratedBirchSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 3), "cratedJungleSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 4), "cratedAcaciaSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 5), "cratedDarkOakSapling");
    }

    @Override
    protected void registerRecipes() {
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(BlockResourceOre.ResourceType.APATITE, 1), PluginCore.items.apatite, 0.5f);
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(BlockResourceOre.ResourceType.COPPER, 1), PluginCore.items.ingotCopper, 0.5f);
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(BlockResourceOre.ResourceType.TIN, 1), PluginCore.items.ingotTin, 0.5f);
        RecipeUtil.addSmelting(new ItemStack((Item)PluginCore.items.peat), PluginCore.items.ash, 0.0f);
        if (Config.isCraftingBronzeEnabled()) {
            RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.ingotBronze, 4), "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        RecipeUtil.addRecipe(PluginCore.items.sturdyCasing, "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.can"), " # ", "# #", Character.valueOf('#'), "ingotTin");
        ArrayList stoneGear = OreDictionary.getOres((String)"gearStone");
        String gearCenter = !stoneGear.isEmpty() ? "gearStone" : "ingotCopper";
        RecipeUtil.addRecipe(PluginCore.items.gearBronze, " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.gearCopper, " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.gearTin, " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.bronzePickaxe, " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addRecipe(PluginCore.items.bronzeShovel, " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addShapelessRecipe(PluginCore.items.kitPickaxe, new Object[]{PluginCore.items.bronzePickaxe, PluginCore.items.carton});
        RecipeUtil.addShapelessRecipe(PluginCore.items.kitShovel, new Object[]{PluginCore.items.bronzeShovel, PluginCore.items.carton});
        RecipeUtil.addRecipe((Item)PluginCore.items.spectacles, " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "paneGlass");
        RecipeUtil.addRecipe(PluginCore.items.wrench, "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.compost.wheat").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.compost.wheat"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "cropWheat");
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.compost.ash").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.compost.ash"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "dustAsh");
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.fertilizer.apatite").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.fertilizer.apatite"), " # ", " X ", " # ", Character.valueOf('#'), "sand", Character.valueOf('X'), "gemApatite");
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.fertilizer.ash").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.fertilizer.ash"), "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.humus.compost").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.humus.compost"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), PluginCore.items.fertilizerBio});
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.humus.fertilizer").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.humus.fertilizer"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), PluginCore.items.fertilizerCompound});
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.bogearth.bucket").field_77994_a > 0) {
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.bogearth.bucket"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Items.field_151131_as, Character.valueOf('Y'), "sand");
        }
        if (ForestryAPI.activeMode.getStackSetting((String)"recipe.output.bogearth.can").field_77994_a > 0) {
            ItemStack canWater = PluginFluids.items.getContainer(EnumContainerType.CAN, Fluids.WATER).getItemStack();
            ItemStack waxCapsuleWater = PluginFluids.items.getContainer(EnumContainerType.CAPSULE, Fluids.WATER).getItemStack();
            ItemStack refractoryWater = PluginFluids.items.getContainer(EnumContainerType.REFRACTORY, Fluids.WATER).getItemStack();
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.bogearth.can"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), canWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.bogearth.can"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waxCapsuleWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe(ForestryAPI.activeMode.getStackSetting("recipe.output.bogearth.can"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), refractoryWater, Character.valueOf('Y'), "sand");
        }
        RecipeUtil.addRecipe(new ItemStack(Items.field_151007_F), "#", "#", "#", Character.valueOf('#'), PluginCore.items.craftingMaterial.getSilkWisp());
        RecipeUtil.addRecipe(PluginCore.items.pipette, "  #", " X ", "X  ", Character.valueOf('X'), "paneGlass", Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorage.get(BlockResourceStorage.ResourceType.APATITE), "###", "###", "###", Character.valueOf('#'), "gemApatite");
        RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.apatite, 9), "blockApatite");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorage.get(BlockResourceStorage.ResourceType.COPPER), "###", "###", "###", Character.valueOf('#'), "ingotCopper");
        RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.ingotCopper, 9), "blockCopper");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorage.get(BlockResourceStorage.ResourceType.TIN), "###", "###", "###", Character.valueOf('#'), "ingotTin");
        RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.ingotTin, 9), "blockTin");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorage.get(BlockResourceStorage.ResourceType.BRONZE), "###", "###", "###", Character.valueOf('#'), "ingotBronze");
        RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.ingotBronze, 9), "blockBronze");
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryCore();
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{rootCommand};
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (fuel != null && fuel.func_77973_b() == PluginCore.items.peat) {
                return 2000;
            }
            if (fuel != null && fuel.func_77973_b() == PluginCore.items.bituminousPeat) {
                return 4200;
            }
            return 0;
        }
    }
}

