/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.client;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.client.gui.GuiEssentiaIO;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.registries.EnumCache;

public class Packet_C_EssentiaIOBus
extends ThEClientPacket {
    private static final byte MODE_SET_REDSTONE_CONTROLLED = 0;
    private static final byte MODE_SET_REDSTONE_MODE = 1;
    private static final byte MODE_SET_FILTER_SIZE = 2;
    private static final byte MODE_SEND_FULL_UPDATE = 3;
    private static final byte MODE_SEND_VOID_MODE = 4;
    private RedstoneMode redstoneMode;
    private byte filterSize;
    private boolean redstoneControlled;
    private boolean isVoidAllowed;

    private static Packet_C_EssentiaIOBus newPacket(EntityPlayer player, byte mode) {
        Packet_C_EssentiaIOBus packet = new Packet_C_EssentiaIOBus();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendBusState(EntityPlayer player, RedstoneMode redstoneMode, byte filterSize, boolean redstoneControlled) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)3);
        packet.redstoneMode = redstoneMode;
        packet.filterSize = filterSize;
        packet.redstoneControlled = redstoneControlled;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendFilterSize(EntityPlayer player, byte filterSize) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)2);
        packet.filterSize = filterSize;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendRedstoneControlled(EntityPlayer player, boolean redstoneControlled) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)0);
        packet.redstoneControlled = redstoneControlled;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendRedstoneMode(EntityPlayer player, RedstoneMode redstoneMode) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)1);
        packet.redstoneMode = redstoneMode;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendVoidMode(EntityPlayer player, boolean isVoidAllowed) {
        Packet_C_EssentiaIOBus packet = Packet_C_EssentiaIOBus.newPacket(player, (byte)4);
        packet.isVoidAllowed = isVoidAllowed;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiEssentiaIO)) {
            return;
        }
        switch (this.mode) {
            case 0: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                break;
            }
            case 1: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                break;
            }
            case 2: {
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                break;
            }
            case 3: {
                ((GuiEssentiaIO)gui).onReceiveRedstoneMode(this.redstoneMode);
                ((GuiEssentiaIO)gui).onReceiveRedstoneControlled(this.redstoneControlled);
                ((GuiEssentiaIO)gui).onReceiveFilterSize(this.filterSize);
                break;
            }
            case 4: {
                ((GuiEssentiaIO)gui).onServerSendVoidMode(this.isVoidAllowed);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.redstoneControlled = stream.readBoolean();
                break;
            }
            case 1: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                break;
            }
            case 2: {
                this.filterSize = stream.readByte();
                break;
            }
            case 3: {
                this.redstoneControlled = stream.readBoolean();
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readByte()];
                this.filterSize = stream.readByte();
                break;
            }
            case 4: {
                this.isVoidAllowed = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                stream.writeBoolean(this.redstoneControlled);
                break;
            }
            case 1: {
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                break;
            }
            case 2: {
                stream.writeByte((int)this.filterSize);
                break;
            }
            case 3: {
                stream.writeBoolean(this.redstoneControlled);
                stream.writeByte((int)((byte)this.redstoneMode.ordinal()));
                stream.writeByte((int)this.filterSize);
                break;
            }
            case 4: {
                stream.writeBoolean(this.isVoidAllowed);
            }
        }
    }
}

