/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.ICropDataProvider;
import growthcraft.core.common.block.IPaddyCrop;
import growthcraft.core.integration.AppleCore;
import growthcraft.rice.GrowthCraftRice;
import growthcraft.rice.client.renderer.RenderRice;
import growthcraft.rice.common.block.BlockPaddy;
import growthcraft.rice.util.RiceBlockCheck;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRice
extends GrcBlockBase
implements IPaddyCrop,
ICropDataProvider,
IGrowable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final float growth;

    public BlockRice() {
        super(Material.field_151585_k);
        this.growth = GrowthCraftRice.getConfig().riceGrowthRate;
        this.func_149711_c(0.0f);
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149663_c("grc.riceBlock");
        this.func_149672_a(field_149779_h);
    }

    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta >= 7;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, int x, int y, int z, int meta) {
        return (float)meta / 7.0f;
    }

    private void incrementGrowth(World world, int x, int y, int z, int meta) {
        world.func_72921_c(x, y, z, meta + 1, 2);
        AppleCore.announceGrowthTick(this, world, x, y, z, meta);
    }

    private void growRice(World world, int x, int y, int z, int meta) {
        this.incrementGrowth(world, x, y, z, meta);
        Block paddyBlock = world.func_147439_a(x, y - 1, z);
        if (RiceBlockCheck.isPaddy(paddyBlock)) {
            ((BlockPaddy)paddyBlock).drainPaddy(world, x, y - 1, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.checkCropChange(world, x, y, z);
        if (world.func_72957_l(x, y + 1, z) >= 9 && world.func_72805_g(x, y - 1, z) > 0) {
            Event.Result allowGrowthResult = AppleCore.validateGrowthTick(this, world, x, y, z, random);
            if (allowGrowthResult == Event.Result.DENY) {
                return;
            }
            int meta = world.func_72805_g(x, y, z);
            if (meta < 7) {
                float f = this.getGrowthRate(world, x, y, z);
                if (allowGrowthResult == Event.Result.ALLOW || random.nextInt((int)(this.growth / f) + 1) == 0) {
                    this.growRice(world, x, y, z, meta);
                }
            }
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return world.func_72805_g(x, y, z) < 7;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 7) {
            this.growRice(world, x, y, z, meta);
        }
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        float f = 1.0f;
        Block l = world.func_147439_a(x, y, z - 1);
        Block i1 = world.func_147439_a(x, y, z + 1);
        Block j1 = world.func_147439_a(x - 1, y, z);
        Block k1 = world.func_147439_a(x + 1, y, z);
        Block l1 = world.func_147439_a(x - 1, y, z - 1);
        Block i2 = world.func_147439_a(x + 1, y, z - 1);
        Block j2 = world.func_147439_a(x + 1, y, z + 1);
        Block k2 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = j1 == this || k1 == this;
        boolean flag1 = l == this || i1 == this;
        boolean flag2 = l1 == this || i2 == this || j2 == this || k2 == this;
        for (int loop_i = x - 1; loop_i <= x + 1; ++loop_i) {
            for (int loop_k = z - 1; loop_k <= z + 1; ++loop_k) {
                Block soil = world.func_147439_a(loop_i, y - 1, loop_k);
                float f1 = 0.0f;
                if (soil != null && RiceBlockCheck.isPaddy(soil)) {
                    f1 = 1.0f;
                    if (world.func_72805_g(loop_i, y - 1, loop_k) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (loop_i != x || loop_k != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    protected final void checkCropChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        this.checkCropChange(world, x, y, z);
    }

    protected boolean canThisPlantGrowOnThisBlockID(Block block) {
        return RiceBlockCheck.isPaddy(block);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && this.canThisPlantGrowOnThisBlockID(world.func_147439_a(x, y - 1, z));
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return GrowthCraftRice.items.rice.getItem();
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        return GrowthCraftRice.items.rice.getItem();
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public void func_149690_a(World world, int x, int y, int z, int par5, float par6, int par7) {
        super.func_149690_a(world, x, y, z, par5, par6, 0);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (metadata >= 7) {
            for (int n = 0; n < 3 + fortune; ++n) {
                if (world.field_73012_v.nextInt(15) > metadata) continue;
                ret.add(GrowthCraftRice.items.rice.asStack(1));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[5];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a("grcrice:rice_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta > 7) {
            meta = 7;
        }
        int i = 0;
        switch (meta) {
            case 0: 
            case 1: {
                i = 0;
                break;
            }
            case 2: 
            case 3: {
                i = 1;
                break;
            }
            case 4: 
            case 5: {
                i = 2;
                break;
            }
            case 6: {
                i = 3;
                break;
            }
            case 7: {
                i = 4;
                break;
            }
            default: {
                i = 2;
            }
        }
        return this.icons[i];
    }

    public int func_149645_b() {
        return RenderRice.id;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public static class RiceStage {
        public static final int MATURE = 7;

        private RiceStage() {
        }
    }
}

