/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.eventhandler.PlayerInteractEventPaddy;
import growthcraft.core.integration.NEI;
import growthcraft.core.util.MapGenHelper;
import growthcraft.rice.GrcRiceConfig;
import growthcraft.rice.common.CommonProxy;
import growthcraft.rice.common.village.ComponentVillageRiceField;
import growthcraft.rice.common.village.VillageHandlerRice;
import growthcraft.rice.event.BonemealEventRice;
import growthcraft.rice.init.GrcRiceBlocks;
import growthcraft.rice.init.GrcRiceFluids;
import growthcraft.rice.init.GrcRiceItems;
import growthcraft.rice.integration.ForestryModule;
import growthcraft.rice.integration.MFRModule;
import growthcraft.rice.integration.ThaumcraftModule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="Growthcraft|Rice", name="Growthcraft Rice", version="1.7.10-2.7.3", dependencies="required-after:Growthcraft@1.7.10-2.7.3;required-after:Growthcraft|Cellar@1.7.10-2.7.3")
public class GrowthCraftRice {
    public static final String MOD_ID = "Growthcraft|Rice";
    public static final String MOD_NAME = "Growthcraft Rice";
    public static final String MOD_VERSION = "1.7.10-2.7.3";
    @Mod.Instance(value="Growthcraft|Rice")
    public static GrowthCraftRice instance;
    public static final GrcRiceBlocks blocks;
    public static final GrcRiceItems items;
    public static final GrcRiceFluids fluids;
    private final ILogger logger = new GrcLogger("Growthcraft|Rice");
    private final GrcRiceConfig config = new GrcRiceConfig();
    private final ModuleContainer modules = new ModuleContainer();

    public static GrcRiceConfig getConfig() {
        return GrowthCraftRice.instance.config;
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/rice.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        this.modules.add(fluids);
        if (this.config.enableForestryIntegration) {
            this.modules.add(new ForestryModule());
        }
        if (this.config.enableMFRIntegration) {
            this.modules.add(new MFRModule());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        this.modules.preInit();
        this.register();
    }

    private void register() {
        this.modules.register();
        MinecraftForge.addGrassSeed((ItemStack)GrowthCraftRice.items.rice.asStack(), (int)this.config.riceSeedDropRarity);
        MapGenHelper.registerVillageStructure(ComponentVillageRiceField.class, "grc.ricefield");
        OreDictionary.registerOre((String)"cropRice", GrowthCraftRice.items.rice.getItem());
        OreDictionary.registerOre((String)"seedRice", GrowthCraftRice.items.rice.getItem());
        OreDictionary.registerOre((String)"listAllseed", GrowthCraftRice.items.rice.getItem());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftRice.items.riceBall.asStack(1), new Object[]{"###", "###", Character.valueOf('#'), "cropRice"}));
        NEI.hideItem(GrowthCraftRice.blocks.riceBlock.asStack());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void initVillageHandlers() {
        VillageHandlerRice handler = new VillageHandlerRice();
        int brewerID = GrowthCraftCellar.getConfig().villagerBrewerID;
        if (brewerID > 0) {
            VillagerRegistry.instance().registerVillageTradeHandler(brewerID, (VillagerRegistry.IVillageTradeHandler)handler);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)handler);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        PlayerInteractEventPaddy.paddyBlocks.put(Blocks.field_150458_ak, (Block)GrowthCraftRice.blocks.paddyField.getBlock());
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            for (int i = 0; i < GrowthCraftRice.fluids.riceSakeBooze.length; ++i) {
                GrowthCraftRice.fluids.riceSakeBooze[i].setIcons(GrowthCraftCore.liquidSmoothTexture);
            }
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new BonemealEventRice());
        this.modules.postInit();
    }

    static {
        blocks = new GrcRiceBlocks();
        items = new GrcRiceItems();
        fluids = new GrcRiceFluids();
    }
}

