/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.fluids.FluidUtils;
import growthcraft.api.core.item.ItemTest;
import growthcraft.api.core.nbt.NBTTagStringList;
import growthcraft.api.core.stream.StreamUtils;
import growthcraft.api.milk.MilkFluidTags;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.api.milk.cheesevat.ICheeseVatRecipe;
import growthcraft.cellar.common.tileentity.component.TileHeatingComponent;
import growthcraft.core.common.inventory.AccesibleSlots;
import growthcraft.core.common.inventory.GrcInternalInventory;
import growthcraft.core.common.inventory.InventoryProcessor;
import growthcraft.core.common.tileentity.GrcTileDeviceBase;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.event.TileEventHandler;
import growthcraft.core.common.tileentity.feature.IItemHandler;
import growthcraft.core.common.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.common.tileentity.feature.ITileNamedFluidTanks;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import growthcraft.core.util.ItemUtils;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.EnumCheeseType;
import growthcraft.milk.common.tileentity.cheesevat.CheeseVatState;
import growthcraft.milk.event.EventCheeseVat;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityCheeseVat
extends GrcTileDeviceBase
implements IItemHandler,
ITileHeatedDevice,
ITileNamedFluidTanks,
ITileProgressiveDevice {
    private static FluidTankType[] recipeTanks = new FluidTankType[]{FluidTankType.PRIMARY, FluidTankType.RECIPE};
    private static AccesibleSlots accessibleSlots = new AccesibleSlots(new int[][]{{0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}});
    private DeviceFluidSlot primaryFluidSlot;
    private DeviceFluidSlot rennetFluidSlot;
    private DeviceFluidSlot wasteFluidSlot;
    private boolean recheckRecipe;
    private TileHeatingComponent heatComponent;
    private CheeseVatState vatState;
    private float progress;
    private int progressMax;

    public TileEntityCheeseVat() {
        this.primaryFluidSlot = new DeviceFluidSlot(this, FluidTankType.PRIMARY.id);
        this.rennetFluidSlot = new DeviceFluidSlot(this, FluidTankType.RENNET.id);
        this.wasteFluidSlot = new DeviceFluidSlot(this, FluidTankType.WASTE.id);
        this.heatComponent = new TileHeatingComponent(this, 0.5f);
        this.vatState = CheeseVatState.IDLE;
    }

    public boolean isIdle() {
        return this.vatState == CheeseVatState.IDLE;
    }

    public boolean isWorking() {
        return !this.isIdle();
    }

    private void setVatState(CheeseVatState state) {
        this.vatState = state;
        this.func_70296_d();
    }

    private void goIdle() {
        this.setVatState(CheeseVatState.IDLE);
    }

    private void setupProgress(int value) {
        this.progress = 0.0f;
        this.progressMax = value;
    }

    private void resetProgress() {
        this.setupProgress(0);
    }

    @Override
    public float getDeviceProgress() {
        if (this.progressMax > 0) {
            return this.progress / (float)this.progressMax;
        }
        return 0.0f;
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        if (this.progressMax > 0) {
            return (int)(this.progress * (float)scale / (float)this.progressMax);
        }
        return 0;
    }

    @Override
    public boolean isHeated() {
        return this.heatComponent.getHeatMultiplier() > 0.0f;
    }

    @Override
    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    @Override
    public int getHeatScaled(int scale) {
        return (int)((float)scale * MathHelper.func_76131_a((float)this.getHeatMultiplier(), (float)0.0f, (float)1.0f));
    }

    public void markForRecipeCheck() {
        this.recheckRecipe = true;
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.markForRecipeCheck();
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(GrowthCraftMilk.getConfig().cheeseVatPrimaryTankCapacity), new FluidTank(GrowthCraftMilk.getConfig().cheeseVatRennetTankCapacity), new FluidTank(GrowthCraftMilk.getConfig().cheeseVatWasteTankCapacity), new FluidTank(GrowthCraftMilk.getConfig().cheeseVatRecipeTankCapacity)};
    }

    public int getVatFluidCapacity() {
        return this.getFluidTank(FluidTankType.PRIMARY.id).getCapacity() + this.getFluidTank(FluidTankType.WASTE.id).getCapacity() + this.getFluidTank(FluidTankType.RECIPE.id).getCapacity();
    }

    @Override
    public GrcInternalInventory createInventory() {
        return new GrcInternalInventory(this, 3, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.CheeseVat";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return accessibleSlots.slotsAt(side);
    }

    @Override
    public boolean func_102008_b(int index, ItemStack stack, int side) {
        return accessibleSlots.sideContains(side, index);
    }

    private boolean activateCurdTransition(boolean checkOnly) {
        ItemStack starterCultureStack = GrowthCraftMilk.items.starterCulture.asStack();
        int slot = InventoryProcessor.instance().findItemSlot((IInventory)this, starterCultureStack);
        if (slot < 0) {
            GrowthCraftMilk.getLogger().debug("No Starter Culture found!", new Object[0]);
            return false;
        }
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (!FluidTest.hasTags(milkStack, MilkFluidTags.MILK)) {
            GrowthCraftMilk.getLogger().debug("Primary Fluid is NOT milk.", new Object[0]);
            return false;
        }
        if (!this.primaryFluidSlot.isFull()) {
            GrowthCraftMilk.getLogger().debug("Primary Fluid Tank is NOT full.", new Object[0]);
            return false;
        }
        FluidStack rennetStack = this.rennetFluidSlot.get();
        if (!FluidTest.hasTags(rennetStack, MilkFluidTags.RENNET)) {
            GrowthCraftMilk.getLogger().debug("Rennet contains NON rennet fluid.", new Object[0]);
            return false;
        }
        if (!this.rennetFluidSlot.isFull()) {
            GrowthCraftMilk.getLogger().debug("Rennet Fluid Tank is NOT full.", new Object[0]);
            return false;
        }
        if (!checkOnly) {
            this.func_70298_a(slot, 1);
            this.primaryFluidSlot.set(FluidUtils.exchangeFluid(milkStack, GrowthCraftMilk.fluids.curds.getFluid()));
            this.rennetFluidSlot.clear();
            this.wasteFluidSlot.fill(GrowthCraftMilk.fluids.whey.fluid.asFluidStack(GrowthCraftMilk.getConfig().cheeseVatMilkToCurdsWheyAmount), true);
            GrowthCraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCurds(this));
        }
        return true;
    }

    private boolean activateWheyTransition(boolean checkOnly) {
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(milkStack, MilkFluidTags.WHEY) && this.primaryFluidSlot.isFull()) {
            if (!checkOnly) {
                Fluid fluid = GrowthCraftMilk.fluids.cheeses.get(EnumCheeseType.RICOTTA).getFluid();
                this.primaryFluidSlot.set(FluidUtils.exchangeFluid(this.primaryFluidSlot.get(), fluid));
                this.wasteFluidSlot.fill(GrowthCraftMilk.fluids.whey.fluid.asFluidStack(GrowthCraftMilk.getConfig().cheeseVatWheyToRicottaWheyAmount), true);
                GrowthCraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCheeseFluid(this));
            }
            return true;
        }
        return false;
    }

    private boolean commitMilkCurdRecipe(boolean checkOnly) {
        ItemStack stack;
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (FluidTankType t : recipeTanks) {
            FluidStack stack2 = this.getFluidStack(t.id);
            if (!FluidTest.isValid(stack2)) continue;
            fluids.add(stack2);
        }
        for (int i = 0; i < this.func_70302_i_() && (stack = this.func_70301_a(i)) != null; ++i) {
            items.add(stack);
        }
        ICheeseVatRecipe recipe = MilkRegistry.instance().cheeseVat().findRecipe(fluids, items);
        if (recipe != null) {
            List<IMultiItemStacks> inputItems = recipe.getInputItemStacks();
            List<IMultiFluidStacks> inputFluids = recipe.getInputFluidStacks();
            int[] invSlots = InventoryProcessor.instance().findItemSlots((IInventory)this, inputItems);
            if (InventoryProcessor.instance().slotsAreValid((IInventory)this, invSlots) && InventoryProcessor.instance().checkSlotsAndSizes((IInventory)this, inputItems, invSlots) && FluidTest.hasEnoughAndExpected(inputFluids, fluids)) {
                if (!checkOnly) {
                    InventoryProcessor.instance().consumeItemsInSlots((IInventory)this, inputItems, invSlots);
                    for (int fluidIndex = 0; fluidIndex < fluids.size(); ++fluidIndex) {
                        FluidStack fluidStack = (FluidStack)fluids.get(fluidIndex);
                        FluidTankType t = recipeTanks[fluidIndex];
                        if (fluidStack == null) continue;
                        this.drainFluidTank(t.id, fluidStack.amount, true);
                    }
                    for (ItemStack stack3 : recipe.getOutputItemStacks()) {
                        if (stack3 == null) continue;
                        ItemUtils.spawnItemStackAtTile(stack3.func_77946_l(), this, this.field_145850_b.field_73012_v);
                    }
                    int tankIndex = 0;
                    Iterator<FluidStack> iterator = recipe.getOutputFluidStacks().iterator();
                    if (iterator.hasNext()) {
                        FluidStack stack4 = iterator.next();
                        if (stack4 != null) {
                            this.fillFluidTank(tankIndex, stack4.copy(), true);
                        }
                        ++tankIndex;
                    }
                    this.func_70296_d();
                    GrowthCraftMilk.MILK_BUS.post((Event)new EventCheeseVat.EventCheeseVatMadeCheeseFluid(this));
                }
                return true;
            }
        }
        return false;
    }

    private void commitRecipe() {
        FluidStack stack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(stack, MilkFluidTags.MILK_CURDS) && this.commitMilkCurdRecipe(true)) {
            this.setupProgress(GrowthCraftMilk.getConfig().cheeseVatCheeseTime);
            this.setVatState(CheeseVatState.PREPARING_CHEESE);
        }
    }

    private void onFinishedProgress() {
        switch (this.vatState) {
            case PREPARING_RICOTTA: {
                this.activateWheyTransition(false);
                break;
            }
            case PREPARING_CURDS: {
                this.activateCurdTransition(false);
                break;
            }
            case PREPARING_CHEESE: {
                this.commitMilkCurdRecipe(false);
                break;
            }
        }
        this.resetProgress();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.heatComponent.update();
            if (!this.isIdle()) {
                if (this.isHeated()) {
                    if (this.progress < (float)this.progressMax) {
                        this.progress += 1.0f * this.getHeatMultiplier();
                    } else {
                        this.onFinishedProgress();
                        this.goIdle();
                    }
                } else if (this.progress > 0.0f) {
                    this.progress -= 1.0f;
                } else {
                    this.goIdle();
                }
            } else if (this.recheckRecipe) {
                this.recheckRecipe = false;
                if (this.isHeated()) {
                    this.commitRecipe();
                }
            }
        }
    }

    private boolean primaryTankHasMilk() {
        return FluidTest.hasTags(this.primaryFluidSlot.get(), MilkFluidTags.MILK);
    }

    private boolean primaryTankHasCurds() {
        return FluidTest.hasTags(this.primaryFluidSlot.get(), MilkFluidTags.MILK_CURDS);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidTest.hasTags(fluid, MilkFluidTags.MILK) || FluidTest.hasTags(fluid, MilkFluidTags.WHEY) || FluidTest.hasTags(fluid, MilkFluidTags.RENNET) || MilkRegistry.instance().cheeseVat().isFluidIngredient(fluid);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, int amount, boolean doDrain) {
        if (!this.isIdle()) {
            return null;
        }
        return this.wasteFluidSlot.consume(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, FluidStack stack, boolean doDrain) {
        if (!FluidTest.areStacksEqual(this.wasteFluidSlot.get(), stack)) {
            return null;
        }
        return this.doDrain(dir, stack.amount, doDrain);
    }

    @Override
    protected int doFill(ForgeDirection dir, FluidStack stack, boolean doFill) {
        if (!this.isIdle()) {
            return 0;
        }
        int result = 0;
        if (FluidTest.hasTags(stack, MilkFluidTags.MILK) || FluidTest.hasTags(stack, MilkFluidTags.WHEY)) {
            result = this.primaryFluidSlot.fill(stack, doFill);
        } else if (FluidTest.isValidAndExpected(GrowthCraftMilk.fluids.rennet.getFluid(), stack)) {
            if (this.primaryTankHasMilk()) {
                result = this.rennetFluidSlot.fill(stack, doFill);
            }
        } else if (MilkRegistry.instance().cheeseVat().isFluidIngredient(stack) && this.primaryTankHasCurds()) {
            result = this.fillFluidTank(FluidTankType.RECIPE.id, stack, doFill);
        }
        return result;
    }

    private void playSuccessfulSwordActivationFX() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.successful_hit", 0.3f, 0.5f);
    }

    private boolean doSwordActivation(EntityPlayer _player, ItemStack _stack) {
        if (!this.isHeated()) {
            GrowthCraftMilk.getLogger().debug("Vat is NOT heated.", new Object[0]);
            return false;
        }
        GrowthCraftMilk.getLogger().debug("Activating Using Sword.", new Object[0]);
        FluidStack milkStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(milkStack, MilkFluidTags.MILK)) {
            GrowthCraftMilk.getLogger().debug("Activating Curd Transition.", new Object[0]);
            if (this.activateCurdTransition(true)) {
                this.setupProgress(GrowthCraftMilk.getConfig().cheeseVatCurdTime);
                this.setVatState(CheeseVatState.PREPARING_CURDS);
                this.playSuccessfulSwordActivationFX();
                return true;
            }
        } else if (FluidTest.hasTags(milkStack, MilkFluidTags.WHEY)) {
            GrowthCraftMilk.getLogger().debug("Activating Whey Transition.", new Object[0]);
            if (this.activateWheyTransition(true)) {
                this.setupProgress(GrowthCraftMilk.getConfig().cheeseVatWheyTime);
                this.setVatState(CheeseVatState.PREPARING_RICOTTA);
                this.playSuccessfulSwordActivationFX();
                return true;
            }
        }
        return false;
    }

    private boolean collectCurdInCheeseCloth(EntityPlayer player, ItemStack stack) {
        Fluid fluid;
        EnumCheeseType type;
        FluidStack fluidStack = this.primaryFluidSlot.get();
        if (FluidTest.hasTags(fluidStack, MilkFluidTags.CHEESE) && (type = GrowthCraftMilk.fluids.fluidToCheeseType.get(fluid = fluidStack.getFluid())) != null) {
            this.primaryFluidSlot.clear();
            ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
            ItemStack curdItemStack = type.asCurdItemStack();
            ItemUtils.addStackToPlayer(curdItemStack, player, false);
            return true;
        }
        return false;
    }

    private boolean addItemIngredient(EntityPlayer player, ItemStack stack) {
        int slot = InventoryProcessor.instance().findNextEmpty((IInventory)this);
        if (slot == -1) {
            return false;
        }
        ItemStack result = ItemUtils.decrPlayerCurrentInventorySlot(player, 1);
        this.func_70299_a(slot, result);
        return true;
    }

    @Override
    public boolean tryPlaceItem(IItemHandler.Action action, EntityPlayer player, ItemStack stack) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        if (!this.isIdle()) {
            return false;
        }
        if (!ItemTest.isValid(stack)) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSword) {
            return this.doSwordActivation(player, stack);
        }
        if (GrowthCraftMilk.items.starterCulture.equals(item)) {
            return this.addItemIngredient(player, stack);
        }
        if (GrowthCraftMilk.items.cheeseCloth.equals(item)) {
            return this.collectCurdInCheeseCloth(player, stack);
        }
        if (MilkRegistry.instance().cheeseVat().isItemIngredient(stack)) {
            return this.addItemIngredient(player, stack);
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemHandler.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemHandler.Action.RIGHT != action) {
            return false;
        }
        if (!this.isIdle()) {
            return false;
        }
        if (onHand == null) {
            int slot = InventoryProcessor.instance().findNextPresentFromEnd((IInventory)this);
            if (slot == -1) {
                return false;
            }
            ItemStack stack = InventoryProcessor.instance().yankSlot((IInventory)this, slot);
            ItemUtils.spawnItemStackAtEntity(stack, (Entity)player, this.field_145850_b.field_73012_v);
            return true;
        }
        return false;
    }

    @Override
    protected void markFluidDirty() {
        this.markForRecipeCheck();
        this.func_70296_d();
    }

    @Override
    public void writeFluidTankNamesToTag(NBTTagCompound tag) {
        NBTTagStringList tagList = new NBTTagStringList();
        for (FluidTankType type : FluidTankType.VALUES) {
            tagList.add(type.getUnlocalizedName());
        }
        tag.func_74782_a("tank_names", (NBTBase)tagList.getTag());
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheeseVat(NBTTagCompound nbt) {
        if (nbt.func_74764_b("progress_max")) {
            this.progressMax = nbt.func_74762_e("progress_max");
        }
        if (nbt.func_74764_b("progress")) {
            this.progress = nbt.func_74760_g("progress");
        }
        this.heatComponent.readFromNBT(nbt, "heat_component");
        this.vatState = CheeseVatState.getStateSafe(nbt.func_74779_i("vat_state"));
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheeseVat(NBTTagCompound nbt) {
        nbt.func_74768_a("progress_max", this.progressMax);
        nbt.func_74776_a("progress", this.progress);
        this.heatComponent.writeToNBT(nbt, "heat_component");
        nbt.func_74778_a("vat_state", this.vatState.name);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheeseVat(ByteBuf stream) throws IOException {
        this.progressMax = stream.readInt();
        this.progress = stream.readFloat();
        this.heatComponent.readFromStream(stream);
        String name = "idle";
        try {
            name = StreamUtils.readStringASCII(stream);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.vatState = CheeseVatState.getStateSafe(name);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheeseVat(ByteBuf stream) throws IOException {
        stream.writeInt(this.progressMax);
        stream.writeFloat(this.progress);
        this.heatComponent.writeToStream(stream);
        try {
            StreamUtils.writeStringASCII(stream, this.vatState.name);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public int calcRedstone() {
        return this.getFluidAmountScaled(15, FluidTankType.PRIMARY.id);
    }

    public static enum FluidTankType {
        PRIMARY,
        RENNET,
        WASTE,
        RECIPE;

        public static final FluidTankType[] VALUES;
        public final int id = this.ordinal();
        public final String name = this.name().toLowerCase(Locale.ENGLISH);

        public String getUnlocalizedName() {
            return "grcmilk.cheese_vat.fluid_tank." + this.name;
        }

        static {
            VALUES = new FluidTankType[]{PRIMARY, RENNET, WASTE, RECIPE};
        }
    }
}

