/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.util.BBox;
import growthcraft.core.common.block.GrcBlockContainer;
import growthcraft.core.util.ItemUtils;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.client.render.RenderCheeseBlock;
import growthcraft.milk.common.item.EnumCheeseStage;
import growthcraft.milk.common.item.EnumCheeseType;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.tileentity.TileEntityCheeseBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCheeseBlock
extends GrcBlockContainer {
    @SideOnly(value=Side.CLIENT)
    private Map<EnumCheeseType, Map<EnumCheeseStage, IIcon[]>> iconMap;

    public BlockCheeseBlock() {
        super(Material.field_151568_F);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149775_l);
        this.func_149663_c("grcmilk.CheeseBlock");
        this.func_149647_a(GrowthCraftMilk.creativeTab);
        this.setTileEntityType(TileEntityCheeseBlock.class);
        BBox bb = BBox.newCube(4.0f, 0.0f, 4.0f, 8.0f, 8.0f, 8.0f).scale(0.0625f);
        this.func_149676_a(bb.x0(), bb.y0(), bb.z0(), bb.x1(), bb.y1(), bb.z1());
    }

    @Override
    protected boolean shouldRestoreBlockState(World world, int x, int y, int z, ItemStack stack) {
        return true;
    }

    @Override
    protected boolean shouldDropTileStack(World world, int x, int y, int z, int metadata, int fortune) {
        return false;
    }

    @Override
    protected ItemStack createHarvestedBlockItemStack(World world, EntityPlayer player, int x, int y, int z, int meta) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            return te.asItemStack();
        }
        return new ItemStack((Block)this, 1, meta);
    }

    @Override
    protected void getTileItemStackDrops(List<ItemStack> ret, World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            ret.add(te.asItemStack());
        } else {
            super.getTileItemStackDrops(ret, world, x, y, z, metadata, fortune);
        }
    }

    @Override
    protected boolean shouldScatterInventoryOnBreak(World world, int x, int y, int z) {
        return true;
    }

    @Override
    protected void scatterInventory(World world, int x, int y, int z, Block block) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            te.populateDrops(drops);
            for (ItemStack stack : drops) {
                ItemUtils.spawnItemStack(world, x, y, z, stack, this.rand);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityCheeseBlock teCheeseBlock = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (teCheeseBlock != null) {
            return teCheeseBlock.asItemStack();
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            te.populateDrops(ret);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        if (item instanceof ItemBlockCheeseBlock) {
            ItemBlockCheeseBlock ib = (ItemBlockCheeseBlock)item;
            for (EnumCheeseType cheese : EnumCheeseType.VALUES) {
                if (!cheese.hasBlock()) continue;
                for (EnumCheeseStage stage : cheese.stages) {
                    ItemStack stack = new ItemStack(item, 1, cheese.meta);
                    NBTTagCompound tag = ib.getTileTagCompound(stack);
                    stage.writeToNBT(tag);
                    list.add(stack);
                }
            }
        }
    }

    public int func_149645_b() {
        return RenderCheeseBlock.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.iconMap = new HashMap<EnumCheeseType, Map<EnumCheeseStage, IIcon[]>>();
        for (EnumCheeseType type : EnumCheeseType.VALUES) {
            if (!type.hasBlock()) continue;
            this.iconMap.put(type, new HashMap());
            String prefix = "grcmilk:cheese/" + type.name;
            for (EnumCheeseStage stage : type.stages) {
                IIcon[] icons = new IIcon[]{reg.func_94245_a(String.format("%s_%s/bottom", prefix, stage.name)), reg.func_94245_a(String.format("%s_%s/top", prefix, stage.name)), reg.func_94245_a(String.format("%s_%s/side", prefix, stage.name))};
                this.iconMap.get(type).put(stage, icons);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIconByTypeAndStage(int side, EnumCheeseType type, EnumCheeseStage stage) {
        IIcon[] icons = this.iconMap.get(type).get((Object)stage);
        if (side == 0) {
            return icons[0];
        }
        if (side == 1) {
            return icons[1];
        }
        return icons[2];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        EnumCheeseType type = EnumCheeseType.getSafeById(meta);
        EnumCheeseStage stage = type.stages.get(0);
        if (te != null) {
            type = te.getCheese().getType();
            stage = te.getCheese().getStage();
        }
        return this.getIconByTypeAndStage(side, type, stage);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        EnumCheeseType type = EnumCheeseType.getSafeById(meta);
        return this.getIconByTypeAndStage(side, type, type.stages.get(0));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }
}

