/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.init;

import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.effect.EffectAddPotionEffect;
import growthcraft.api.core.effect.EffectWeightedRandomList;
import growthcraft.api.core.effect.SimplePotionEffectFactory;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.TickUtils;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.block.BlockFluidBooze;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.ItemBoozeBottle;
import growthcraft.cellar.util.BoozeRegistryHelper;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.grapes.GrowthCraftGrapes;
import growthcraft.grapes.common.item.EnumGrapes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GrcGrapesFluids
extends GrcModuleBase {
    public Booze[] grapeWineBooze;
    public BlockBoozeDefinition[] grapeWineFluids;
    public ItemDefinition grapeWine;
    public ItemBucketBoozeDefinition[] grapeWineBuckets;

    @Override
    public void preInit() {
        this.grapeWineBooze = new Booze[8];
        this.grapeWineFluids = new BlockBoozeDefinition[this.grapeWineBooze.length];
        this.grapeWineBuckets = new ItemBucketBoozeDefinition[this.grapeWineBooze.length];
        BoozeRegistryHelper.initializeBoozeFluids("grc.grapeWine", this.grapeWineBooze);
        for (Booze booze : this.grapeWineBooze) {
            booze.setColor(GrowthCraftGrapes.getConfig().grapeWineColor).setDensity(1120);
        }
        BoozeRegistryHelper.initializeBooze(this.grapeWineBooze, this.grapeWineFluids, this.grapeWineBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.grapeWineBooze, 1, -0.3f);
        BoozeRegistryHelper.setBoozeFoodStats(this.grapeWineBooze[0], 1, 0.3f);
        this.grapeWineBooze[4].setColor(GrowthCraftGrapes.getConfig().ambrosiaColor);
        ((BlockFluidBooze)((Object)this.grapeWineFluids[4].getBlock())).refreshColor();
        this.grapeWineBooze[5].setColor(GrowthCraftGrapes.getConfig().portWineColor);
        ((BlockFluidBooze)((Object)this.grapeWineFluids[5].getBlock())).refreshColor();
        this.grapeWine = new ItemDefinition((Item)new ItemBoozeBottle(this.grapeWineBooze));
    }

    private void registerFermentations() {
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        FluidStack[] fs = new FluidStack[this.grapeWineBooze.length];
        for (int i = 0; i < this.grapeWineBooze.length; ++i) {
            fs[i] = new FluidStack((Fluid)this.grapeWineBooze[i], 1);
        }
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[0]).tags(BoozeTag.YOUNG).pressesFrom(EnumGrapes.PURPLE.asStack(), TickUtils.seconds(2), 40, Residue.newDefault(0.3f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[1]).tags(BoozeTag.WINE, BoozeTag.FERMENTED).fermentsFrom(fs[0], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[0], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76429_m, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[2]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[1], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.07f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76429_m, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[3]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76429_m, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[4]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[2], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.053f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76434_w, TickUtils.minutes(3), 0).addPotionEntry(Potion.field_76429_m, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[5]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.FORTIFIED).brewsFrom(new FluidStack((Fluid)this.grapeWineBooze[1], GrowthCraftGrapes.getConfig().portWineBrewingYield), new OreItemStacks("yeastBayanus"), GrowthCraftGrapes.getConfig().portWineBrewingTime, Residue.newDefault(0.3f)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.2f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76429_m, TickUtils.minutes(3), 2);
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[6]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[2], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76429_m.field_76415_H, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76437_t.field_76415_H, TickUtils.minutes(3), 2))));
        GrowthCraftCellar.boozeBuilderFactory.create(this.grapeWineBooze[7]).tags(BoozeTag.WINE, BoozeTag.FERMENTED, BoozeTag.POISONED).fermentsTo(fs[1], new OreItemStacks("yeastPoison"), fermentTime).fermentsTo(fs[2], new OreItemStacks("yeastPoison"), fermentTime).fermentsTo(fs[3], new OreItemStacks("yeastPoison"), fermentTime).fermentsTo(fs[4], new OreItemStacks("yeastPoison"), fermentTime).fermentsTo(fs[5], new OreItemStacks("yeastPoison"), fermentTime).fermentsTo(fs[6], new OreItemStacks("yeastPoison"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), TickUtils.seconds(90)).createPotionEntry(Potion.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthCraftCore.getConfig().hidePoisonedBooze);
    }

    @Override
    public void register() {
        this.grapeWine.register("grc.grapeWine");
        BoozeRegistryHelper.registerBooze(this.grapeWineBooze, this.grapeWineFluids, this.grapeWineBuckets, this.grapeWine, "grc.grapeWine", null);
        this.registerFermentations();
        OreDictionary.registerOre((String)"foodGrapejuice", (ItemStack)this.grapeWine.asStack(1, 0));
    }
}

