/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.fishtrap;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.api.fishtrap.FishTrapEntry;
import growthcraft.api.fishtrap.user.UserBaitConfig;
import growthcraft.api.fishtrap.user.UserCatchGroupConfig;
import growthcraft.api.fishtrap.user.UserFishTrapConfig;
import growthcraft.core.GrcGuiProvider;
import growthcraft.core.common.definition.BlockDefinition;
import growthcraft.fishtrap.GrcFishtrapConfig;
import growthcraft.fishtrap.common.CommonProxy;
import growthcraft.fishtrap.common.block.BlockFishTrap;
import growthcraft.fishtrap.common.tileentity.TileEntityFishTrap;
import growthcraft.fishtrap.integration.ThaumcraftModule;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="Growthcraft|Fishtrap", name="Growthcraft Fishtrap", version="1.7.10-2.7.3", dependencies="required-after:Growthcraft@1.7.10-2.7.3")
public class GrowthCraftFishTrap {
    public static final String MOD_ID = "Growthcraft|Fishtrap";
    public static final String MOD_NAME = "Growthcraft Fishtrap";
    public static final String MOD_VERSION = "1.7.10-2.7.3";
    @Mod.Instance(value="Growthcraft|Fishtrap")
    public static GrowthCraftFishTrap instance;
    public static BlockDefinition fishTrap;
    public static final GrcGuiProvider guiProvider;
    private final ILogger logger = new GrcLogger("Growthcraft|Fishtrap");
    private final GrcFishtrapConfig config = new GrcFishtrapConfig();
    private final ModuleContainer modules = new ModuleContainer();
    private final UserBaitConfig userBaitConfig = new UserBaitConfig();
    private final UserCatchGroupConfig userCatchGroupConfig = new UserCatchGroupConfig();
    private final UserFishTrapConfig userFishTrapConfig = new UserFishTrapConfig();

    public static GrcFishtrapConfig getConfig() {
        return GrowthCraftFishTrap.instance.config;
    }

    public static ILogger getLogger() {
        return GrowthCraftFishTrap.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/fishtrap.conf");
        this.userBaitConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/fishtrap/baits.json");
        this.userCatchGroupConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/fishtrap/catch_groups.json");
        this.userFishTrapConfig.setConfigFile(event.getModConfigurationDirectory(), "growthcraft/fishtrap/entries.json");
        this.modules.add(this.userBaitConfig);
        this.modules.add(this.userCatchGroupConfig);
        this.modules.add(this.userFishTrapConfig);
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        fishTrap = new BlockDefinition(new BlockFishTrap());
        this.modules.preInit();
        this.register();
    }

    private void register() {
        GameRegistry.registerBlock(fishTrap.getBlock(), (String)"grc.fishTrap");
        GameRegistry.registerTileEntity(TileEntityFishTrap.class, (String)"grc.tileentity.fishTrap");
        this.userBaitConfig.addDefault(new ItemStack(Items.field_151078_bh), 0.2f, 1.1f);
        this.userCatchGroupConfig.addDefault("junk", 7, "Useless Stuff");
        this.userCatchGroupConfig.addDefault("treasure", 2, "Fancy Stuff");
        this.userCatchGroupConfig.addDefault("fish", 20, "Fishes");
        this.userCatchGroupConfig.addDefault("mineral", 3, "Ingots and other metallic stuff");
        this.userCatchGroupConfig.addDefault("legendary", 1, "Stuff you probably would never find on average");
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack((Item)Items.field_151021_T), 5).setDamage(0.9f));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151116_aA), 5));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151103_aS), 5));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack((Item)Items.field_151068_bn), 3));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151007_F), 5));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack((Item)Items.field_151112_aM), 2).setDamage(0.9f));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151054_z), 5));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151055_y), 10));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151100_aR, 5), 1));
        this.userFishTrapConfig.addDefault("junk", new FishTrapEntry(new ItemStack(Items.field_151078_bh), 5));
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack(Blocks.field_150392_bi), 3));
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack(Items.field_151057_cb), 1));
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack(Items.field_151141_av), 1));
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack((Item)Items.field_151031_f), 1).setDamage(0.25f).setEnchantable());
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack((Item)Items.field_151112_aM), 1).setDamage(0.25f).setEnchantable());
        this.userFishTrapConfig.addDefault("treasure", new FishTrapEntry(new ItemStack(Items.field_151122_aG), 1).setEnchantable());
        this.userFishTrapConfig.addDefault("fish", new FishTrapEntry(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60));
        this.userFishTrapConfig.addDefault("fish", new FishTrapEntry(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25));
        this.userFishTrapConfig.addDefault("fish", new FishTrapEntry(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2));
        this.userFishTrapConfig.addDefault("fish", new FishTrapEntry(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));
        this.userFishTrapConfig.addDefault("mineral", new FishTrapEntry(new ItemStack((Block)Blocks.field_150479_bC), 1));
        this.userFishTrapConfig.addDefault("mineral", new FishTrapEntry(new ItemStack(Items.field_151042_j), 10));
        this.userFishTrapConfig.addDefault("mineral", new FishTrapEntry(new ItemStack(Items.field_151074_bl), 5));
        this.userFishTrapConfig.addDefault("legendary", new FishTrapEntry(new ItemStack(Items.field_151043_k), 1));
        this.userFishTrapConfig.addDefault("legendary", new FishTrapEntry(new ItemStack(Items.field_151045_i), 10));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(fishTrap.asStack(1), new Object[]{"ACA", "CBC", "ACA", Character.valueOf('A'), "plankWood", Character.valueOf('B'), Items.field_151058_ca, Character.valueOf('C'), Items.field_151007_F}));
        this.modules.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.userBaitConfig.loadUserConfig();
        this.userCatchGroupConfig.loadUserConfig();
        this.userFishTrapConfig.loadUserConfig();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiProvider);
        this.modules.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.modules.postInit();
    }

    static {
        guiProvider = new GrcGuiProvider(new GrcLogger("Growthcraft|Fishtrap:GuiProvider"));
    }
}

