/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTType;
import growthcraft.api.core.util.ITagFormatter;
import growthcraft.core.util.UnitFormatter;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class TagFormatterFluidHandler
implements ITagFormatter {
    public static final TagFormatterFluidHandler INSTANCE = new TagFormatterFluidHandler();

    @Override
    public List<String> format(List<String> list, NBTTagCompound tag) {
        int tankCount = tag.func_74762_e("tank_count");
        NBTTagList tanks = tag.func_150295_c("tanks", NBTType.COMPOUND.id);
        NBTTagList tankNames = tag.func_74764_b("tank_names") ? tag.func_150295_c("tank_names", NBTType.STRING.id) : null;
        for (int i = 0; i < tankCount; ++i) {
            NBTTagCompound tankTag = tanks.func_150305_b(i);
            String name = tankNames != null ? tankNames.func_150307_f(i) : null;
            String content = "";
            if (name != null && name.length() > 0) {
                content = content + GrcI18n.translate(name) + " ";
            } else if (tankCount > 1) {
                content = content + EnumChatFormatting.GRAY + GrcI18n.translate("grc.format.tank_id", tankTag.func_74762_e("tank_id") + 1) + " ";
            }
            int fluidID = tankTag.func_74762_e("fluid_id");
            if (fluidID != 0) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag.func_74775_l("fluid"));
                String fluidName = UnitFormatter.fluidNameForContainer(fluidStack);
                content = content + UnitFormatter.fractionNum(fluidStack.amount, tankTag.func_74762_e("capacity")) + EnumChatFormatting.GRAY + " " + GrcI18n.translate("grc.format.tank.content_suffix", fluidName);
            } else {
                content = content + UnitFormatter.noFluid();
            }
            list.add(content);
        }
        return list;
    }
}

