/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.util;

import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.block.IBlockRope;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCheck {
    public static final ForgeDirection[] DIR4 = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final BlockDirection[] DIR8 = new BlockDirection[]{BlockDirection.NORTH, BlockDirection.SOUTH, BlockDirection.WEST, BlockDirection.EAST, BlockDirection.NORTH_WEST, BlockDirection.NORTH_EAST, BlockDirection.SOUTH_WEST, BlockDirection.SOUTH_EAST};

    private BlockCheck() {
    }

    public static ForgeDirection randomDirection4(Random random) {
        return DIR4[random.nextInt(DIR4.length)];
    }

    public static BlockDirection randomDirection8(Random random) {
        return DIR8[random.nextInt(DIR8.length)];
    }

    public static boolean isWater(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_149688_o() == Material.field_151586_h;
    }

    public static boolean isRopeBlock(Block block) {
        return block instanceof IBlockRope;
    }

    public static boolean isRope(Block block) {
        return GrowthCraftCore.blocks.ropeBlock.equals(block);
    }

    public static boolean isRope(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return BlockCheck.isRope(block);
    }

    public static boolean canSustainPlantOn(IBlockAccess world, int x, int y, int z, ForgeDirection dir, IPlantable plant, Block soil) {
        return soil != null && soil.canSustainPlant(world, x, y, z, dir, plant);
    }

    public static boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection dir, IPlantable plant) {
        Block soil = world.func_147439_a(x, y, z);
        return BlockCheck.canSustainPlantOn(world, x, y, z, dir, plant, soil);
    }

    public static Block getFarmableBlock(IBlockAccess world, int x, int y, int z, ForgeDirection dir, IPlantable plant) {
        Block soil = world.func_147439_a(x, y, z);
        if (BlockCheck.canSustainPlantOn(world, x, y, z, dir, plant, soil)) {
            return soil;
        }
        return null;
    }

    public static boolean isBlockPlacableOnSide(World world, int x, int y, int z, ForgeDirection dir) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b != null) {
            return b.func_149747_d((IBlockAccess)world, x, y, z, dir.ordinal());
        }
        return false;
    }

    public static enum BlockDirection {
        DOWN(0, -1, 0),
        UP(0, 1, 0),
        NORTH(0, 0, -1),
        SOUTH(0, 0, 1),
        WEST(-1, 0, 0),
        EAST(1, 0, 0),
        UNKNOWN(0, 0, 0),
        NORTH_WEST(-1, 0, -1),
        NORTH_EAST(1, 0, -1),
        SOUTH_WEST(-1, 0, 1),
        SOUTH_EAST(1, 0, 1),
        DOWN_NORTH(0, -1, -1),
        DOWN_SOUTH(0, -1, 1),
        DOWN_WEST(-1, -1, 0),
        DOWN_EAST(1, -1, 0),
        DOWN_NORTH_WEST(-1, -1, -1),
        DOWN_NORTH_EAST(1, -1, -1),
        DOWN_SOUTH_WEST(-1, -1, 1),
        DOWN_SOUTH_EAST(1, -1, 1),
        UP_NORTH(0, 1, -1),
        UP_SOUTH(0, 1, 1),
        UP_WEST(-1, 1, 0),
        UP_EAST(1, 1, 0),
        UP_NORTH_WEST(-1, 1, -1),
        UP_NORTH_EAST(1, 1, -1),
        UP_SOUTH_WEST(-1, 1, 1),
        UP_SOUTH_EAST(1, 1, 1);

        public final int offsetX;
        public final int offsetY;
        public final int offsetZ;
        public final int flag;

        private BlockDirection(int x, int y, int z) {
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
            this.flag = 1 << this.ordinal();
        }
    }
}

