/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.util.Platform;

public abstract class ModIntegrationBase
extends GrcModuleBase {
    public final String parentModID;
    public final String modID;
    private boolean modLoaded;

    public ModIntegrationBase(String parentMod, String integratingMod) {
        this.parentModID = parentMod;
        this.modID = integratingMod;
    }

    public boolean modIsLoaded() {
        return this.modLoaded;
    }

    public String getModTag() {
        ModContainer cont = FMLCommonHandler.instance().findContainerFor((Object)this.modID);
        return String.format("%s [%s]", this.modID, cont != null ? cont.getVersion() : "NOT LOADED");
    }

    protected void doPreInit() {
    }

    @Override
    public final void preInit() {
        this.modLoaded = Loader.isModLoaded((String)this.modID);
        if (this.modIsLoaded()) {
            this.logger.debug("preInit " + this.getModTag(), new Object[0]);
            this.doPreInit();
        }
    }

    protected void doInit() {
    }

    @Override
    public final void init() {
        if (this.modIsLoaded()) {
            this.logger.debug("init " + this.getModTag(), new Object[0]);
            this.doInit();
        }
    }

    protected void doRegister() {
    }

    @Override
    public final void register() {
        if (this.modIsLoaded()) {
            this.logger.debug("register " + this.getModTag(), new Object[0]);
            this.doRegister();
        }
    }

    protected void doPostInit() {
    }

    protected void doLateRegister() {
    }

    @Override
    public final void postInit() {
        if (this.modIsLoaded()) {
            this.logger.debug("postInit " + this.getModTag(), new Object[0]);
            this.doPostInit();
            this.doLateRegister();
        }
        this.tryToIntegrate();
    }

    protected void integrate() {
    }

    protected void integrateClient() {
    }

    protected void integrateServer() {
    }

    public void tryToIntegrate() {
        if (this.modIsLoaded()) {
            this.logger.debug("Attemping to integrate with %s.", this.getModTag());
            try {
                if (Platform.isClient()) {
                    this.integrateClient();
                } else {
                    this.integrateServer();
                }
                this.integrate();
                this.logger.debug("Successfully integrated with %s.", this.getModTag());
            }
            catch (Exception e) {
                this.logger.warn("%s integration failed.", this.getModTag());
            }
        } else {
            this.logger.debug("%s not found; No integration made.", this.getModTag());
        }
    }
}

