/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.item;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.item.EnumDye;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.item.GrcItemBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCrowbar
extends GrcItemBase
implements IToolWrench {
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemCrowbar() {
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
        this.setHarvestLevel("wrench", 0);
        this.func_77655_b("grccore.crowbar");
        this.func_111206_d("grccore:crowbar");
        this.func_77637_a(GrowthCraftCore.creativeTab);
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> shift : this.shiftRotations) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (player.func_70093_af() != this.isShiftRotation(block.getClass())) {
            return false;
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71038_i();
    }

    public EnumDye getDye(ItemStack stack) {
        return EnumDye.getByMeta(stack.func_77960_j());
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getDye((ItemStack)stack).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumDye.VALUES.length];
        for (EnumDye dye : EnumDye.VALUES) {
            this.icons[dye.meta] = reg.func_94245_a(String.format("%s/%s", this.func_111208_A(), dye.name));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumDye dye : EnumDye.VALUES) {
            list.add(new ItemStack(item, 1, dye.meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[MathHelper.func_76125_a((int)meta, (int)0, (int)(this.icons.length - 1))];
    }
}

