/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.api.core.effect.IEffect;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.core.common.item.GrcItemBase;
import growthcraft.core.lib.GrcCoreState;
import growthcraft.core.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class GrcItemFoodBase
extends ItemFood {
    private IEffect effect;
    private EnumAction action = EnumAction.eat;

    public GrcItemFoodBase(int hunger, float saturation, boolean isWolfFav) {
        super(hunger, saturation, isWolfFav);
    }

    public GrcItemFoodBase(int hunger, boolean isWolfFav) {
        super(hunger, isWolfFav);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.action;
    }

    public GrcItemFoodBase setItemUseAction(EnumAction act) {
        this.action = act;
        return this;
    }

    public GrcItemFoodBase setEffect(IEffect ef) {
        this.effect = ef;
        return this;
    }

    public IEffect getEffect() {
        return this.effect;
    }

    protected void applyIEffects(ItemStack itemStack, World world, EntityPlayer player) {
        if (this.effect != null) {
            this.effect.apply(world, (Entity)player, world.field_73012_v, itemStack);
        }
    }

    protected void func_77849_c(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77849_c(itemStack, world, player);
        if (!world.field_72995_K) {
            this.applyIEffects(itemStack, world, player);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            ItemStack result = ItemUtils.consumeStack(stack.func_77979_a(1));
            ItemUtils.addStackToPlayer(result, player, world, false);
        }
        player.func_71024_bL().func_151686_a((ItemFood)this, stack);
        world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_77849_c(stack, world, player);
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean showAdvanced) {
        super.func_77624_a(stack, player, list, showAdvanced);
        GrcItemBase.addDescription((Item)this, stack, player, list, showAdvanced);
        if (this.effect != null) {
            ArrayList<String> tempList = new ArrayList<String>();
            this.effect.getDescription(tempList);
            if (tempList.size() > 0) {
                if (GrcCoreState.showDetailedInformation()) {
                    list.addAll(tempList);
                } else {
                    list.add(EnumChatFormatting.GRAY + GrcI18n.translate("grc.tooltip.detailed_information", EnumChatFormatting.WHITE + "SHIFT" + EnumChatFormatting.GRAY));
                }
            }
        }
    }
}

